/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractFutureTest;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Runnables;
import com.google.common.util.concurrent.TestPlatform;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
abstract class AbstractAbstractFutureTest
extends TestCase {
    private TestedFuture<Integer> future;
    private AbstractFuture<Integer> delegate;

    AbstractAbstractFutureTest() {
    }

    abstract AbstractFuture<Integer> newDelegate();

    protected void setUp() {
        this.future = TestedFuture.create();
        this.delegate = this.newDelegate();
    }

    public void testPending() {
        AbstractAbstractFutureTest.assertPending(this.future);
    }

    public void testSuccessful() throws Exception {
        Truth.assertThat((Boolean)this.future.set(1)).isTrue();
        AbstractAbstractFutureTest.assertSuccessful(this.future, 1);
    }

    public void testFailed() throws Exception {
        Exception cause = new Exception();
        Truth.assertThat((Boolean)this.future.setException(cause)).isTrue();
        AbstractAbstractFutureTest.assertFailed(this.future, cause);
    }

    public void testCanceled() throws Exception {
        Truth.assertThat((Boolean)this.future.cancel(false)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, false);
    }

    public void testInterrupted() throws Exception {
        Truth.assertThat((Boolean)this.future.cancel(true)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, true);
    }

    public void testSetFuturePending() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        AbstractAbstractFutureTest.assertSetAsynchronously(this.future);
    }

    public void testSetFutureThenCancel() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        Truth.assertThat((Boolean)this.future.cancel(false)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, false);
        AbstractAbstractFutureTest.assertCancelled(this.delegate, false);
    }

    public void testSetFutureThenInterrupt() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        Truth.assertThat((Boolean)this.future.cancel(true)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, true);
        AbstractAbstractFutureTest.assertCancelled(this.delegate, true);
    }

    public void testSetFutureDelegateAlreadySuccessful() throws Exception {
        this.delegate.set((Object)5);
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        AbstractAbstractFutureTest.assertSuccessful(this.future, 5);
    }

    public void testSetFutureDelegateLaterSuccessful() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        this.delegate.set((Object)6);
        AbstractAbstractFutureTest.assertSuccessful(this.future, 6);
    }

    public void testSetFutureDelegateAlreadyCancelled() throws Exception {
        this.delegate.cancel(false);
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, false);
    }

    public void testSetFutureDelegateLaterCancelled() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        this.delegate.cancel(false);
        AbstractAbstractFutureTest.assertCancelled(this.future, false);
    }

    @GwtIncompatible
    public void testSetFutureDelegateAlreadyInterrupted() throws Exception {
        this.delegate.cancel(true);
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        AbstractAbstractFutureTest.assertCancelled(this.future, this.delegate instanceof AbstractFuture.TrustedFuture);
    }

    @GwtIncompatible
    public void testSetFutureDelegateLaterInterrupted() throws Exception {
        Truth.assertThat((Boolean)this.future.setFuture((ListenableFuture)this.delegate)).isTrue();
        this.delegate.cancel(true);
        AbstractAbstractFutureTest.assertCancelled(this.future, this.delegate instanceof AbstractFuture.TrustedFuture);
    }

    public void testListenLaterSuccessful() {
        CountingRunnable listener = new CountingRunnable();
        this.future.addListener(listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        this.future.set(1);
        listener.assertRun();
    }

    public void testListenLaterFailed() {
        CountingRunnable listener = new CountingRunnable();
        this.future.addListener(listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        this.future.setException(new Exception());
        listener.assertRun();
    }

    public void testListenLaterCancelled() {
        CountingRunnable listener = new CountingRunnable();
        this.future.addListener(listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        this.future.cancel(false);
        listener.assertRun();
    }

    public void testListenLaterInterrupted() {
        CountingRunnable listener = new CountingRunnable();
        this.future.addListener(listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        this.future.cancel(true);
        listener.assertRun();
    }

    public void testListenLaterSetAsynchronously() {
        CountingRunnable listener = new CountingRunnable();
        this.future.addListener(listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        this.future.setFuture((ListenableFuture)this.delegate);
        listener.assertNotRun();
    }

    public void testListenLaterSetAsynchronouslyLaterDelegateSuccessful() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.delegate.set((Object)1);
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testListenLaterSetAsynchronouslyLaterDelegateFailed() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.delegate.setException((Throwable)new Exception());
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testListenLaterSetAsynchronouslyLaterDelegateCancelled() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.delegate.cancel(false);
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testListenLaterSetAsynchronouslyLaterDelegateInterrupted() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.delegate.cancel(true);
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testListenLaterSetAsynchronouslyLaterSelfCancelled() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.future.cancel(false);
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testListenLaterSetAsynchronouslyLaterSelfInterrupted() {
        CountingRunnable before = new CountingRunnable();
        CountingRunnable inBetween = new CountingRunnable();
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.setFuture((ListenableFuture)this.delegate);
        this.future.addListener(inBetween, MoreExecutors.directExecutor());
        this.future.cancel(true);
        this.future.addListener(after, MoreExecutors.directExecutor());
        before.assertRun();
        inBetween.assertRun();
        after.assertRun();
    }

    public void testMisbehavingListenerAlreadyDone() {
        Runnable bad = new Runnable(){

            @Override
            public void run() {
                class BadRunnableException
                extends RuntimeException {
                    BadRunnableException() {
                    }
                }
                throw new BadRunnableException();
            }
        };
        this.future.set(1);
        this.future.addListener(bad, MoreExecutors.directExecutor());
    }

    public void testMisbehavingListenerLaterDone() {
        CountingRunnable before = new CountingRunnable();
        Runnable bad = new Runnable(){

            @Override
            public void run() {
                class BadRunnableException
                extends RuntimeException {
                    BadRunnableException() {
                    }
                }
                throw new BadRunnableException();
            }
        };
        CountingRunnable after = new CountingRunnable();
        this.future.addListener(before, MoreExecutors.directExecutor());
        this.future.addListener(bad, MoreExecutors.directExecutor());
        this.future.addListener(after, MoreExecutors.directExecutor());
        this.future.set(1);
        before.assertRun();
        after.assertRun();
    }

    public void testNullListener() {
        try {
            this.future.addListener(null, MoreExecutors.directExecutor());
            AbstractAbstractFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullExecutor() {
        try {
            this.future.addListener(Runnables.doNothing(), null);
            AbstractAbstractFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullTimeUnit() throws Exception {
        this.future.set(1);
        try {
            this.future.get(0L, null);
            AbstractAbstractFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNegativeTimeout() throws Exception {
        this.future.set(1);
        AbstractAbstractFutureTest.assertEquals((int)1, (int)((Integer)this.future.get(-1L, TimeUnit.SECONDS)));
    }

    @GwtIncompatible
    public void testOverflowTimeout() throws Exception {
        long nanosPerSecond = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        Truth.assertThat((Long)(nanosPerSecond * Long.MAX_VALUE)).isLessThan((Comparable)Long.valueOf(0L));
        AbstractFutureTest.TimedWaiterThread waiter = new AbstractFutureTest.TimedWaiterThread(this.future, Long.MAX_VALUE, TimeUnit.SECONDS);
        waiter.start();
        waiter.awaitWaiting();
        this.future.set(1);
        waiter.join();
    }

    public void testSetNull() throws Exception {
        this.future.set(null);
        AbstractAbstractFutureTest.assertSuccessful(this.future, null);
    }

    public void testSetExceptionNull() throws Exception {
        try {
            this.future.setException(null);
            AbstractAbstractFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Truth.assertThat((Boolean)this.future.isDone()).isFalse();
        Truth.assertThat((Boolean)this.future.set(1)).isTrue();
        AbstractAbstractFutureTest.assertSuccessful(this.future, 1);
    }

    public void testSetFutureNull() throws Exception {
        try {
            this.future.setFuture(null);
            AbstractAbstractFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Truth.assertThat((Boolean)this.future.isDone()).isFalse();
        Truth.assertThat((Boolean)this.future.set(1)).isTrue();
        AbstractAbstractFutureTest.assertSuccessful(this.future, 1);
    }

    private static void assertSetAsynchronously(AbstractFuture<Integer> future) {
        AbstractAbstractFutureTest.assertCannotSet(future);
        AbstractAbstractFutureTest.assertPending(future);
    }

    private static void assertPending(AbstractFuture<Integer> future) {
        Truth.assertThat((Boolean)future.isDone()).isFalse();
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        CountingRunnable listener = new CountingRunnable();
        future.addListener((Runnable)listener, MoreExecutors.directExecutor());
        listener.assertNotRun();
        TestPlatform.verifyGetOnPendingFuture(future);
        TestPlatform.verifyTimedGetOnPendingFuture(future);
    }

    private static void assertSuccessful(AbstractFuture<Integer> future, Integer expectedResult) throws InterruptedException, TimeoutException, ExecutionException {
        AbstractAbstractFutureTest.assertDone(future);
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        Truth.assertThat((Integer)((Integer)Futures.getDone(future))).isEqualTo((Object)expectedResult);
        Truth.assertThat((Integer)TestPlatform.getDoneFromTimeoutOverload(future)).isEqualTo((Object)expectedResult);
    }

    private static void assertFailed(AbstractFuture<Integer> future, Throwable expectedException) throws InterruptedException, TimeoutException {
        AbstractAbstractFutureTest.assertDone(future);
        Truth.assertThat((Boolean)future.isCancelled()).isFalse();
        try {
            Futures.getDone(future);
            AbstractAbstractFutureTest.fail();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isSameAs((Object)expectedException);
        }
        try {
            TestPlatform.getDoneFromTimeoutOverload(future);
            AbstractAbstractFutureTest.fail();
        }
        catch (ExecutionException e) {
            Truth.assertThat((Throwable)e.getCause()).isSameAs((Object)expectedException);
        }
    }

    private static void assertCancelled(AbstractFuture<Integer> future, boolean expectWasInterrupted) throws InterruptedException, TimeoutException, ExecutionException {
        AbstractAbstractFutureTest.assertDone(future);
        Truth.assertThat((Boolean)future.isCancelled()).isTrue();
        Truth.assertThat((Boolean)future.wasInterrupted()).isEqualTo((Object)expectWasInterrupted);
        try {
            Futures.getDone(future);
            AbstractAbstractFutureTest.fail();
        }
        catch (CancellationException expected) {
            // empty catch block
        }
        try {
            TestPlatform.getDoneFromTimeoutOverload(future);
            AbstractAbstractFutureTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    private static void assertDone(AbstractFuture<Integer> future) {
        CountingRunnable listener = new CountingRunnable();
        future.addListener((Runnable)listener, MoreExecutors.directExecutor());
        listener.assertRun();
        Truth.assertThat((Boolean)future.isDone()).isTrue();
        AbstractAbstractFutureTest.assertCannotSet(future);
        AbstractAbstractFutureTest.assertCannotCancel(future);
    }

    private static void assertCannotSet(AbstractFuture<Integer> future) {
        Truth.assertThat((Boolean)future.set((Object)99)).isFalse();
        Truth.assertThat((Boolean)future.setException((Throwable)new IndexOutOfBoundsException())).isFalse();
        Truth.assertThat((Boolean)future.setFuture((ListenableFuture)new AbstractFuture<Integer>(){})).isFalse();
        Truth.assertThat((Boolean)future.setFuture(Futures.immediateFuture((Object)99))).isFalse();
    }

    private static void assertCannotCancel(AbstractFuture<Integer> future) {
        Truth.assertThat((Boolean)future.cancel(true)).isFalse();
        Truth.assertThat((Boolean)future.cancel(false)).isFalse();
    }

    private static final class CountingRunnable
    implements Runnable {
        int count;

        private CountingRunnable() {
        }

        @Override
        public void run() {
            ++this.count;
        }

        void assertNotRun() {
            Assert.assertEquals((int)0, (int)this.count);
        }

        void assertRun() {
            Assert.assertEquals((int)1, (int)this.count);
        }
    }

    private static class TestedFuture<V>
    extends AbstractFuture<V> {
        private TestedFuture() {
        }

        private static <V> TestedFuture<V> create() {
            return new TestedFuture<V>();
        }
    }
}

