/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.testing.MockFutureListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public abstract class AbstractChainedListenableFutureTest<T>
extends TestCase {
    protected static final int EXCEPTION_DATA = -1;
    protected static final int VALID_INPUT_DATA = 1;
    protected static final Exception EXCEPTION = new Exception("Test exception");
    protected SettableFuture<Integer> inputFuture;
    protected ListenableFuture<T> resultFuture;
    protected MockFutureListener listener;

    protected void setUp() throws Exception {
        super.setUp();
        this.inputFuture = SettableFuture.create();
        this.resultFuture = this.buildChainingFuture((ListenableFuture<Integer>)this.inputFuture);
        this.listener = new MockFutureListener(this.resultFuture);
    }

    public void testFutureGetBeforeCallback() throws Exception {
        try {
            this.resultFuture.get(1L, TimeUnit.MILLISECONDS);
            AbstractChainedListenableFutureTest.fail((String)"The data is not yet ready, so a TimeoutException is expected");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testFutureGetThrowsWrappedException() throws Exception {
        this.inputFuture.setException((Throwable)EXCEPTION);
        this.listener.assertException((Throwable)EXCEPTION);
    }

    public void testFutureGetThrowsWrappedError() throws Exception {
        Error error = new Error();
        this.inputFuture.setException((Throwable)error);
        this.listener.assertException((Throwable)error);
    }

    public void testAddListenerAfterCallback() throws Throwable {
        this.inputFuture.set((Object)1);
        this.listener.assertSuccess(this.getSuccessfulResult());
    }

    public void testFutureBeforeCallback() throws Throwable {
        this.inputFuture.set((Object)1);
        this.listener.assertSuccess(this.getSuccessfulResult());
    }

    protected abstract ListenableFuture<T> buildChainingFuture(ListenableFuture<Integer> var1);

    protected abstract T getSuccessfulResult();
}

