/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.AtomicLongMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class AtomicLongMapTest
extends TestCase {
    private static final int ITERATIONS = 100;
    private static final int MAX_ADDEND = 100;
    private Random random = new Random(301L);

    @GwtIncompatible
    public void testNulls() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicConstructors(AtomicLongMap.class);
        tester.testAllPublicStaticMethods(AtomicLongMap.class);
        AtomicLongMap map = AtomicLongMap.create();
        tester.testAllPublicInstanceMethods((Object)map);
    }

    public void testCreate_map() {
        ImmutableMap in = ImmutableMap.of((Object)"1", (Object)1L, (Object)"2", (Object)2L, (Object)"3", (Object)3L);
        AtomicLongMap map = AtomicLongMap.create((Map)in);
        AtomicLongMapTest.assertFalse((boolean)map.isEmpty());
        AtomicLongMapTest.assertSame((Object)3, (Object)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"1"));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"2"));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"3"));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)"1"));
        AtomicLongMapTest.assertEquals((long)2L, (long)map.get((Object)"2"));
        AtomicLongMapTest.assertEquals((long)3L, (long)map.get((Object)"3"));
    }

    public void testIncrementAndGet() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.incrementAndGet((Object)key);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before + 1L), (long)after);
            AtomicLongMapTest.assertEquals((long)after, (long)result);
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((int)100, (int)((int)map.get((Object)key)));
    }

    public void testIncrementAndGet_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.incrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.decrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.incrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)key));
    }

    public void testGetAndIncrement() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.getAndIncrement((Object)key);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before + 1L), (long)after);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((int)100, (int)((int)map.get((Object)key)));
    }

    public void testGetAndIncrement_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndIncrement((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.getAndDecrement((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndIncrement((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)key));
    }

    public void testDecrementAndGet() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.decrementAndGet((Object)key);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before - 1L), (long)after);
            AtomicLongMapTest.assertEquals((long)after, (long)result);
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((int)-100, (int)((int)map.get((Object)key)));
    }

    public void testDecrementAndGet_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.decrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.incrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.decrementAndGet((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.get((Object)key));
    }

    public void testGetAndDecrement() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.getAndDecrement((Object)key);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before - 1L), (long)after);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((int)-100, (int)((int)map.get((Object)key)));
    }

    public void testGetAndDecrement_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndDecrement((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.getAndIncrement((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndDecrement((Object)key));
        AtomicLongMapTest.assertEquals((long)-1L, (long)map.get((Object)key));
    }

    public void testAddAndGet() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long addend = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.addAndGet((Object)key, addend);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before + addend), (long)after);
            AtomicLongMapTest.assertEquals((long)after, (long)result);
            addend = after;
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
    }

    public void testAddAndGet_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long value = this.random.nextInt(100);
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)value, (long)map.addAndGet((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.addAndGet((Object)key, -1L * value));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)value, (long)map.addAndGet((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
    }

    public void testGetAndAdd() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long addend = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.getAndAdd((Object)key, addend);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)(before + addend), (long)after);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            addend = after;
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
    }

    public void testGetAndAdd_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long value = this.random.nextInt(100);
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndAdd((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)value, (long)map.getAndAdd((Object)key, -1L * value));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.getAndAdd((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
    }

    public void testPut() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long newValue = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.put((Object)key, newValue);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)newValue, (long)after);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            newValue += newValue;
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
    }

    public void testPut_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long value = this.random.nextInt(100);
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.put((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)value, (long)map.put((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.put((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
    }

    public void testPutAll() {
        ImmutableMap in = ImmutableMap.of((Object)"1", (Object)1L, (Object)"2", (Object)2L, (Object)"3", (Object)3L);
        AtomicLongMap map = AtomicLongMap.create();
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
        AtomicLongMapTest.assertSame((Object)0, (Object)map.size());
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)"1"));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)"2"));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)"3"));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)"1"));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)"2"));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)"3"));
        map.putAll((Map)in);
        AtomicLongMapTest.assertFalse((boolean)map.isEmpty());
        AtomicLongMapTest.assertSame((Object)3, (Object)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"1"));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"2"));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)"3"));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.get((Object)"1"));
        AtomicLongMapTest.assertEquals((long)2L, (long)map.get((Object)"2"));
        AtomicLongMapTest.assertEquals((long)3L, (long)map.get((Object)"3"));
    }

    public void testPutIfAbsent() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long newValue = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            long result = map.putIfAbsent((Object)key, newValue);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            AtomicLongMapTest.assertEquals((long)(before == 0L ? newValue : before), (long)after);
            map.remove((Object)key);
            before = map.get((Object)key);
            result = map.putIfAbsent((Object)key, newValue);
            after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)0L, (long)before);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            AtomicLongMapTest.assertEquals((long)newValue, (long)after);
            map.put((Object)key, 0L);
            before = map.get((Object)key);
            result = map.putIfAbsent((Object)key, newValue);
            after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)0L, (long)before);
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            AtomicLongMapTest.assertEquals((long)newValue, (long)after);
            newValue += newValue;
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
    }

    public void testPutIfAbsent_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long value = this.random.nextInt(100);
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.putIfAbsent((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
        AtomicLongMapTest.assertEquals((long)value, (long)map.put((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.putIfAbsent((Object)key, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
    }

    public void testReplace() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long newValue = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            long before = map.get((Object)key);
            AtomicLongMapTest.assertFalse((boolean)map.replace((Object)key, before + 1L, newValue + 1L));
            AtomicLongMapTest.assertFalse((boolean)map.replace((Object)key, before - 1L, newValue - 1L));
            AtomicLongMapTest.assertTrue((boolean)map.replace((Object)key, before, newValue));
            long after = map.get((Object)key);
            AtomicLongMapTest.assertEquals((long)newValue, (long)after);
            newValue += newValue;
        }
        AtomicLongMapTest.assertEquals((int)1, (int)map.size());
        AtomicLongMapTest.assertTrue((!map.isEmpty() ? 1 : 0) != 0);
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
    }

    public void testReplace_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        long value = this.random.nextInt(100);
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.replace((Object)key, 0L, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.replace((Object)key, value, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.replace((Object)key, 0L, value));
        AtomicLongMapTest.assertEquals((long)value, (long)map.get((Object)key));
    }

    public void testRemove() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
        AtomicLongMapTest.assertEquals((long)0L, (long)map.remove((Object)key));
        long newValue = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            map.put((Object)key, newValue);
            AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
            long before = map.get((Object)key);
            long result = map.remove((Object)key);
            long after = map.get((Object)key);
            AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
            AtomicLongMapTest.assertEquals((long)before, (long)result);
            AtomicLongMapTest.assertEquals((long)0L, (long)after);
            newValue += newValue;
        }
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testRemove_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.remove((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.put((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.remove((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
    }

    public void testRemoveIfZero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
        AtomicLongMapTest.assertFalse((boolean)map.removeIfZero((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.incrementAndGet((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.removeIfZero((Object)key));
        AtomicLongMapTest.assertEquals((long)2L, (long)map.incrementAndGet((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.removeIfZero((Object)key));
        AtomicLongMapTest.assertEquals((long)1L, (long)map.decrementAndGet((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.removeIfZero((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.decrementAndGet((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.removeIfZero((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
    }

    public void testRemoveValue() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
        AtomicLongMapTest.assertFalse((boolean)map.remove((Object)key, 0L));
        long newValue = this.random.nextInt(100);
        for (int i = 0; i < 100; ++i) {
            map.put((Object)key, newValue);
            AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
            long before = map.get((Object)key);
            AtomicLongMapTest.assertFalse((boolean)map.remove((Object)key, newValue + 1L));
            AtomicLongMapTest.assertFalse((boolean)map.remove((Object)key, newValue - 1L));
            AtomicLongMapTest.assertTrue((boolean)map.remove((Object)key, newValue));
            long after = map.get((Object)key);
            AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
            AtomicLongMapTest.assertEquals((long)0L, (long)after);
            newValue += newValue;
        }
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testRemoveValue_zero() {
        AtomicLongMap map = AtomicLongMap.create();
        String key = "key";
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.remove((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.put((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.containsKey((Object)key));
        AtomicLongMapTest.assertTrue((boolean)map.remove((Object)key, 0L));
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)key));
        AtomicLongMapTest.assertFalse((boolean)map.containsKey((Object)key));
    }

    public void testRemoveZeros() {
        AtomicLongMap map = AtomicLongMap.create();
        HashSet nonZeroKeys = Sets.newHashSet();
        for (int i = 0; i < 100; ++i) {
            Object key = new Object();
            long value = i % 2;
            map.put(key, value);
            if (value == 0L) continue;
            nonZeroKeys.add(key);
        }
        AtomicLongMapTest.assertEquals((int)100, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.asMap().containsValue(0L));
        map.removeAllZeros();
        AtomicLongMapTest.assertFalse((boolean)map.asMap().containsValue(0L));
        AtomicLongMapTest.assertEquals((int)50, (int)map.size());
        AtomicLongMapTest.assertEquals((Object)nonZeroKeys, map.asMap().keySet());
    }

    public void testClear() {
        AtomicLongMap map = AtomicLongMap.create();
        for (int i = 0; i < 100; ++i) {
            map.put(new Object(), (long)i);
        }
        AtomicLongMapTest.assertEquals((int)100, (int)map.size());
        map.clear();
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testSum() {
        AtomicLongMap map = AtomicLongMap.create();
        long sum = 0L;
        for (int i = 0; i < 100; ++i) {
            map.put(new Object(), (long)i);
            sum += (long)i;
        }
        AtomicLongMapTest.assertEquals((int)100, (int)map.size());
        AtomicLongMapTest.assertEquals((long)sum, (long)map.sum());
    }

    public void testEmpty() {
        AtomicLongMap map = AtomicLongMap.create();
        AtomicLongMapTest.assertEquals((long)0L, (long)map.get((Object)"a"));
        AtomicLongMapTest.assertEquals((int)0, (int)map.size());
        AtomicLongMapTest.assertTrue((boolean)map.isEmpty());
        AtomicLongMapTest.assertFalse((boolean)map.remove((Object)"a", 1L));
        AtomicLongMapTest.assertFalse((boolean)map.remove((Object)"a", 0L));
        AtomicLongMapTest.assertFalse((boolean)map.replace((Object)"a", 1L, 0L));
    }

    @GwtIncompatible
    public void testModify_basher() throws InterruptedException {
        int nTasks = 3000;
        int nThreads = 100;
        int getsPerTask = 1000;
        int deltaRange = 10000;
        String key = "key";
        final AtomicLong sum = new AtomicLong();
        final AtomicLongMap map = AtomicLongMap.create();
        ExecutorService threadPool = Executors.newFixedThreadPool(nThreads);
        for (int i = 0; i < nTasks; ++i) {
            threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    int threadSum = 0;
                    block12: for (int j = 0; j < 1000; ++j) {
                        long delta = AtomicLongMapTest.this.random.nextInt(10000);
                        int behavior = AtomicLongMapTest.this.random.nextInt(10);
                        switch (behavior) {
                            case 0: {
                                map.incrementAndGet((Object)"key");
                                ++threadSum;
                                continue block12;
                            }
                            case 1: {
                                map.decrementAndGet((Object)"key");
                                --threadSum;
                                continue block12;
                            }
                            case 2: {
                                map.addAndGet((Object)"key", delta);
                                threadSum = (int)((long)threadSum + delta);
                                continue block12;
                            }
                            case 3: {
                                map.getAndIncrement((Object)"key");
                                ++threadSum;
                                continue block12;
                            }
                            case 4: {
                                map.getAndDecrement((Object)"key");
                                --threadSum;
                                continue block12;
                            }
                            case 5: {
                                map.getAndAdd((Object)"key", delta);
                                threadSum = (int)((long)threadSum + delta);
                                continue block12;
                            }
                            case 6: {
                                long oldValue = map.put((Object)"key", delta);
                                threadSum = (int)((long)threadSum + (delta - oldValue));
                                continue block12;
                            }
                            case 7: {
                                long oldValue = map.get((Object)"key");
                                if (!map.replace((Object)"key", oldValue, delta)) continue block12;
                                threadSum = (int)((long)threadSum + (delta - oldValue));
                                continue block12;
                            }
                            case 8: {
                                long oldValue = map.remove((Object)"key");
                                threadSum = (int)((long)threadSum - oldValue);
                                continue block12;
                            }
                            case 9: {
                                long oldValue = map.get((Object)"key");
                                if (!map.remove((Object)"key", oldValue)) continue block12;
                                threadSum = (int)((long)threadSum - oldValue);
                                continue block12;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    sum.addAndGet(threadSum);
                }
            });
        }
        threadPool.shutdown();
        AtomicLongMapTest.assertTrue((boolean)threadPool.awaitTermination(300L, TimeUnit.SECONDS));
        AtomicLongMapTest.assertEquals((long)sum.get(), (long)map.get((Object)"key"));
    }
}

