/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.FuturesGetChecked;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.acl.NotOwnerException;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.zip.DataFormatException;
import javax.security.auth.RefreshFailedException;

public class FuturesGetCheckedBenchmark {
    private static final ImmutableSet<Class<? extends Exception>> OTHER_EXCEPTION_TYPES = ImmutableSet.of(BackingStoreException.class, BrokenBarrierException.class, CloneNotSupportedException.class, DataFormatException.class, ExecutionException.class, GeneralSecurityException.class, (Object[])new Class[]{InvalidPreferencesFormatException.class, NotOwnerException.class, RefreshFailedException.class, TimeoutException.class, TooManyListenersException.class, URISyntaxException.class});
    @Param
    Validator validator;
    @Param
    Result result;
    @Param
    ExceptionType exceptionType;
    @Param(value={"0", "1", "12"})
    int otherEntriesInDataStructure;
    final List<ClassValue<?>> retainedReferencesToOtherClassValues = Lists.newArrayList();

    @BeforeExperiment
    void addOtherEntries() throws Exception {
        FuturesGetChecked.GetCheckedTypeValidator validator = this.validator.validator;
        Class<? extends Exception> exceptionType = this.exceptionType.exceptionType;
        for (Class exceptionClass : OTHER_EXCEPTION_TYPES.asList().subList(0, this.otherEntriesInDataStructure)) {
            FuturesGetChecked.getChecked((FuturesGetChecked.GetCheckedTypeValidator)validator, (Future)Futures.immediateFuture((Object)""), (Class)exceptionClass);
        }
        for (int i = 0; i < this.otherEntriesInDataStructure; ++i) {
            ClassValue<Boolean> classValue = new ClassValue<Boolean>(){

                @Override
                protected Boolean computeValue(Class<?> type) {
                    return true;
                }
            };
            classValue.get(exceptionType);
            this.retainedReferencesToOtherClassValues.add(classValue);
        }
    }

    @Benchmark
    int benchmarkGetChecked(int reps) {
        int tmp = 0;
        FuturesGetChecked.GetCheckedTypeValidator validator = this.validator.validator;
        Future<Object> future = this.result.future;
        Class<? extends Exception> exceptionType = this.exceptionType.exceptionType;
        for (int i = 0; i < reps; ++i) {
            try {
                tmp += FuturesGetChecked.getChecked((FuturesGetChecked.GetCheckedTypeValidator)validator, future, exceptionType).hashCode();
                continue;
            }
            catch (Exception e) {
                tmp += e.hashCode();
            }
        }
        return tmp;
    }

    private static FuturesGetChecked.GetCheckedTypeValidator nonCachingWithoutConstructorCheckValidator() {
        return NonCachingWithoutConstructorCheckValidator.INSTANCE;
    }

    private static FuturesGetChecked.GetCheckedTypeValidator nonCachingWithConstructorCheckValidator() {
        return NonCachingWithConstructorCheckValidator.INSTANCE;
    }

    static /* synthetic */ FuturesGetChecked.GetCheckedTypeValidator access$000() {
        return FuturesGetCheckedBenchmark.nonCachingWithConstructorCheckValidator();
    }

    static /* synthetic */ FuturesGetChecked.GetCheckedTypeValidator access$100() {
        return FuturesGetCheckedBenchmark.nonCachingWithoutConstructorCheckValidator();
    }

    private static enum NonCachingWithConstructorCheckValidator implements FuturesGetChecked.GetCheckedTypeValidator
    {
        INSTANCE;


        public void validateClass(Class<? extends Exception> exceptionClass) {
            FuturesGetChecked.checkExceptionClassValidity(exceptionClass);
        }
    }

    private static enum NonCachingWithoutConstructorCheckValidator implements FuturesGetChecked.GetCheckedTypeValidator
    {
        INSTANCE;


        public void validateClass(Class<? extends Exception> exceptionClass) {
            Preconditions.checkArgument((boolean)FuturesGetChecked.isCheckedException(exceptionClass), (String)"Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        }
    }

    private static enum ExceptionType {
        CHECKED(IOException.class),
        UNCHECKED(RuntimeException.class);

        final Class<? extends Exception> exceptionType;

        private ExceptionType(Class<? extends Exception> exceptionType) {
            this.exceptionType = exceptionType;
        }
    }

    private static enum Result {
        SUCCESS((Future<Object>)Futures.immediateFuture((Object)new Object())),
        FAILURE((Future<Object>)Futures.immediateFailedFuture((Throwable)new Exception()));

        final Future<Object> future;

        private Result(Future<Object> result) {
            this.future = result;
        }
    }

    private static enum Validator {
        NON_CACHING_WITH_CONSTRUCTOR_CHECK(FuturesGetCheckedBenchmark.access$000()),
        NON_CACHING_WITHOUT_CONSTRUCTOR_CHECK(FuturesGetCheckedBenchmark.access$100()),
        WEAK_SET(FuturesGetChecked.weakSetValidator()),
        CLASS_VALUE(FuturesGetChecked.classValueValidator());

        final FuturesGetChecked.GetCheckedTypeValidator validator;

        private Validator(FuturesGetChecked.GetCheckedTypeValidator validator) {
            this.validator = validator;
        }
    }
}

