/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.lang.reflect.Constructor;
import java.util.concurrent.BlockingQueue;

public class MonitorBenchmark {
    @Param(value={"10", "100", "1000"})
    int capacity;
    @Param(value={"Array", "Priority"})
    String queueType;
    @Param
    boolean useMonitor;
    private BlockingQueue<String> queue;
    private String[] strings;

    @BeforeExperiment
    void setUp() throws Exception {
        String prefix = this.useMonitor ? "com.google.common.util.concurrent.MonitorBased" : "java.util.concurrent.";
        String className = prefix + this.queueType + "BlockingQueue";
        Constructor<?> constructor = Class.forName(className).getConstructor(Integer.TYPE);
        this.queue = (BlockingQueue)constructor.newInstance(this.capacity);
        this.strings = new String[this.capacity];
        for (int i = 0; i < this.capacity; ++i) {
            this.strings[i] = String.valueOf(Math.random());
        }
    }

    @Benchmark
    void addsAndRemoves(int reps) {
        int capacity = this.capacity;
        BlockingQueue<String> queue = this.queue;
        String[] strings = this.strings;
        for (int i = 0; i < reps; ++i) {
            int j;
            for (j = 0; j < capacity; ++j) {
                queue.add(strings[j]);
            }
            for (j = 0; j < capacity; ++j) {
                queue.remove();
            }
        }
    }
}

