/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.AfterExperiment;
import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.Footprint;
import com.google.caliper.api.VmOptions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

@VmOptions(value={"-Xms12g", "-Xmx12g", "-d64"})
public class MoreExecutorsDirectExecutorBenchmark {
    @Param
    Impl impl;
    Executor executor;
    CountingRunnable countingRunnable = new CountingRunnable();
    Set<Thread> threads = new HashSet<Thread>();

    @BeforeExperiment
    void before() {
        this.executor = this.impl.executor();
        for (int i = 0; i < 4; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    CountingRunnable localRunnable = new CountingRunnable();
                    while (!this.isInterrupted()) {
                        MoreExecutorsDirectExecutorBenchmark.this.executor.execute(localRunnable);
                    }
                    MoreExecutorsDirectExecutorBenchmark.this.countingRunnable.integer.addAndGet(localRunnable.integer.get());
                }
            };
            this.threads.add(thread);
        }
    }

    @AfterExperiment
    void after() {
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    @Footprint
    Object measureSize() {
        return this.executor;
    }

    @Benchmark
    int timeUncontendedExecute(int reps) {
        Executor executor = this.executor;
        CountingRunnable countingRunnable = this.countingRunnable;
        for (int i = 0; i < reps; ++i) {
            executor.execute(countingRunnable);
        }
        return countingRunnable.integer.get();
    }

    @Benchmark
    int timeContendedExecute(int reps) {
        Executor executor = this.executor;
        for (Thread thread : this.threads) {
            if (thread.isAlive()) continue;
            thread.start();
        }
        CountingRunnable countingRunnable = this.countingRunnable;
        for (int i = 0; i < reps; ++i) {
            executor.execute(countingRunnable);
        }
        return countingRunnable.integer.get();
    }

    static final class CountingRunnable
    implements Runnable {
        AtomicInteger integer = new AtomicInteger();

        CountingRunnable() {
        }

        @Override
        public void run() {
            this.integer.incrementAndGet();
        }
    }

    static enum Impl {
        EXECUTOR_SERVICE{

            @Override
            Executor executor() {
                return MoreExecutors.newDirectExecutorService();
            }
        }
        ,
        EXECUTOR{

            @Override
            Executor executor() {
                return MoreExecutors.directExecutor();
            }
        };


        abstract Executor executor();
    }
}

