/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTester;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class SettableFutureTest
extends TestCase {
    private SettableFuture<String> future;
    private ListenableFutureTester tester;

    protected void setUp() throws Exception {
        super.setUp();
        this.future = SettableFuture.create();
        this.tester = new ListenableFutureTester((ListenableFuture<?>)this.future);
        this.tester.setUp();
    }

    public void testDefaultState() throws Exception {
        try {
            this.future.get(5L, TimeUnit.MILLISECONDS);
            SettableFutureTest.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testSetValue() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.set((Object)"value"));
        this.tester.testCompletedFuture("value");
    }

    public void testSetFailure() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.setException((Throwable)new Exception("failure")));
        this.tester.testFailedFuture("failure");
    }

    public void testSetFailureNull() throws Exception {
        try {
            this.future.setException(null);
            SettableFutureTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        SettableFutureTest.assertFalse((boolean)this.future.isDone());
        SettableFutureTest.assertTrue((boolean)this.future.setException((Throwable)new Exception("failure")));
        this.tester.testFailedFuture("failure");
    }

    public void testCancel() throws Exception {
        SettableFutureTest.assertTrue((boolean)this.future.cancel(true));
        this.tester.testCancelledFuture();
    }

    public void testCreate() throws Exception {
        SettableFuture future = SettableFuture.create();
        SettableFutureTest.assertFalse((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
    }

    public void testSetValue_simpleThreaded() throws Exception {
        SettableFuture future = SettableFuture.create();
        SettableFutureTest.assertTrue((boolean)future.set((Object)42));
        SettableFutureTest.assertFalse((boolean)future.set((Object)23));
        SettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        SettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        SettableFutureTest.assertTrue((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        SettableFutureTest.assertEquals((int)42, (int)((Integer)future.get()));
    }

    public void testSetException() throws Exception {
        SettableFuture future = SettableFuture.create();
        Exception e = new Exception("foobarbaz");
        SettableFutureTest.assertTrue((boolean)future.setException((Throwable)e));
        SettableFutureTest.assertFalse((boolean)future.set((Object)23));
        SettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("quux")));
        SettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        SettableFutureTest.assertTrue((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get();
            SettableFutureTest.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException ee) {
            SettableFutureTest.assertSame((Object)e, (Object)ee.getCause());
        }
    }

    public void testSetFuture() throws Exception {
        SettableFuture future = SettableFuture.create();
        SettableFuture nested = SettableFuture.create();
        SettableFutureTest.assertTrue((boolean)future.setFuture((ListenableFuture)nested));
        SettableFutureTest.assertFalse((boolean)future.set((Object)"x"));
        SettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        SettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        SettableFutureTest.assertFalse((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            SettableFutureTest.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        nested.set((Object)"foo");
        SettableFutureTest.assertTrue((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        SettableFutureTest.assertEquals((String)"foo", (String)((String)future.get()));
    }

    public void testSetFuture_genericsHierarchy() throws Exception {
        SettableFuture future = SettableFuture.create();
        SettableFuture nested = SettableFuture.create();
        SettableFutureTest.assertTrue((boolean)future.setFuture((ListenableFuture)nested));
        SettableFutureTest.assertFalse((boolean)future.set((Object)new Foo()));
        SettableFutureTest.assertFalse((boolean)future.setException((Throwable)new Exception("bar")));
        SettableFutureTest.assertFalse((boolean)future.setFuture((ListenableFuture)SettableFuture.create()));
        SettableFutureTest.assertFalse((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        try {
            future.get(0L, TimeUnit.MILLISECONDS);
            SettableFutureTest.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException expected) {
            // empty catch block
        }
        FooChild value = new FooChild();
        nested.set((Object)value);
        SettableFutureTest.assertTrue((boolean)future.isDone());
        SettableFutureTest.assertFalse((boolean)future.isCancelled());
        SettableFutureTest.assertSame((Object)value, (Object)future.get());
    }

    public void testCancel_innerCancelsAsync() throws Exception {
        SettableFuture async = SettableFuture.create();
        SettableFuture inner = SettableFuture.create();
        async.setFuture((ListenableFuture)inner);
        inner.cancel(true);
        SettableFutureTest.assertTrue((boolean)async.isCancelled());
        try {
            async.get();
            SettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_resultCancelsInner_interrupted() throws Exception {
        SettableFuture async = SettableFuture.create();
        SettableFuture inner = SettableFuture.create();
        async.setFuture((ListenableFuture)inner);
        async.cancel(true);
        SettableFutureTest.assertTrue((boolean)inner.isCancelled());
        SettableFutureTest.assertTrue((boolean)inner.wasInterrupted());
        try {
            inner.get();
            SettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_resultCancelsInner() throws Exception {
        SettableFuture async = SettableFuture.create();
        SettableFuture inner = SettableFuture.create();
        async.setFuture((ListenableFuture)inner);
        async.cancel(false);
        SettableFutureTest.assertTrue((boolean)inner.isCancelled());
        SettableFutureTest.assertFalse((boolean)inner.wasInterrupted());
        try {
            inner.get();
            SettableFutureTest.fail((String)"Expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testCancel_beforeSet() throws Exception {
        SettableFuture async = SettableFuture.create();
        async.cancel(true);
        SettableFutureTest.assertFalse((boolean)async.set((Object)42));
    }

    public void testCancel_multipleBeforeSetFuture_noInterruptFirst() throws Exception {
        SettableFuture async = SettableFuture.create();
        async.cancel(false);
        async.cancel(true);
        SettableFuture inner = SettableFuture.create();
        SettableFutureTest.assertFalse((boolean)async.setFuture((ListenableFuture)inner));
        SettableFutureTest.assertTrue((boolean)inner.isCancelled());
        SettableFutureTest.assertFalse((boolean)inner.wasInterrupted());
    }

    public void testCancel_multipleBeforeSetFuture_interruptFirst() throws Exception {
        SettableFuture async = SettableFuture.create();
        async.cancel(true);
        async.cancel(false);
        SettableFuture inner = SettableFuture.create();
        SettableFutureTest.assertFalse((boolean)async.setFuture((ListenableFuture)inner));
        SettableFutureTest.assertTrue((boolean)inner.isCancelled());
        SettableFutureTest.assertTrue((boolean)inner.wasInterrupted());
    }

    private static class FooChild
    extends Foo {
        private FooChild() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

