/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FuturesTest;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

@GwtCompatible(emulated=true)
final class TestPlatform {
    static void verifyGetOnPendingFuture(Future<?> future) {
        Preconditions.checkNotNull(future);
        try {
            FuturesTest.pseudoTimedGetUninterruptibly(future, 10L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException expected) {
        }
        catch (ExecutionException e) {
            throw FuturesTest.failureWithCause(e, "");
        }
    }

    static void verifyTimedGetOnPendingFuture(Future<?> future) {
        try {
            Uninterruptibles.getUninterruptibly(future, (long)0L, (TimeUnit)TimeUnit.SECONDS);
            Assert.fail();
        }
        catch (TimeoutException expected) {
        }
        catch (ExecutionException e) {
            throw FuturesTest.failureWithCause(e, "");
        }
    }

    static void verifyThreadWasNotInterrupted() {
        Assert.assertFalse((boolean)Thread.currentThread().isInterrupted());
    }

    static void clearInterrupt() {
        Thread.interrupted();
    }

    static <V> V getDoneFromTimeoutOverload(Future<V> future) throws ExecutionException {
        Preconditions.checkState((boolean)future.isDone(), (String)"Future was expected to be done: %s", future);
        try {
            return (V)Uninterruptibles.getUninterruptibly(future, (long)0L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            AssertionFailedError error = new AssertionFailedError(e.getMessage());
            error.initCause((Throwable)e);
            throw error;
        }
    }

    private TestPlatform() {
    }
}

