/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.TearDown;
import com.google.common.testing.TearDownAccepter;
import com.google.common.testing.TearDownStack;
import com.google.common.util.concurrent.InterruptionUtil;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class UninterruptibleFutureTest
extends TestCase {
    private SleepingRunnable sleeper;
    private Future<Boolean> delayedFuture;
    private final TearDownStack tearDownStack = new TearDownStack();
    private static final String RESULT = "result";

    protected void setUp() {
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        this.tearDownStack.addTearDown(new TearDown(){

            public void tearDown() {
                executor.shutdownNow();
            }
        });
        this.sleeper = new SleepingRunnable(1000);
        this.delayedFuture = executor.submit(this.sleeper, true);
        this.tearDownStack.addTearDown(new TearDown(){

            public void tearDown() {
                Thread.interrupted();
            }
        });
    }

    protected void tearDown() {
        this.tearDownStack.runTearDown();
    }

    public void testRegularFutureInterrupted() throws ExecutionException {
        InterruptionUtil.requestInterruptIn(200L, TimeUnit.MILLISECONDS);
        UninterruptibleFutureTest.assertFalse((boolean)Thread.interrupted());
        try {
            this.delayedFuture.get(1000L, TimeUnit.MILLISECONDS);
            UninterruptibleFutureTest.fail((String)"expected to be interrupted");
        }
        catch (InterruptedException expected) {
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        UninterruptibleFutureTest.assertFalse((boolean)Thread.interrupted());
        UninterruptibleFutureTest.assertFalse((boolean)this.sleeper.completed);
        try {
            UninterruptibleFutureTest.assertTrue((boolean)this.delayedFuture.get());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        UninterruptibleFutureTest.assertTrue((boolean)this.sleeper.completed);
    }

    public void testMakeUninterruptible_timeoutPreservedThroughInterruption() throws ExecutionException {
        InterruptionUtil.repeatedlyInterruptTestThread(100L, (TearDownAccepter)this.tearDownStack);
        try {
            Uninterruptibles.getUninterruptibly(this.delayedFuture, (long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            UninterruptibleFutureTest.fail((String)"expected to time out");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        UninterruptibleFutureTest.assertTrue((boolean)Thread.interrupted());
        UninterruptibleFutureTest.assertFalse((boolean)this.sleeper.completed);
        UninterruptibleFutureTest.assertTrue((boolean)((Boolean)Uninterruptibles.getUninterruptibly(this.delayedFuture)));
        UninterruptibleFutureTest.assertTrue((boolean)Thread.interrupted());
        UninterruptibleFutureTest.assertTrue((boolean)this.sleeper.completed);
    }

    public void testMakeUninterruptible_untimed_uninterrupted() throws Exception {
        UninterruptibleFutureTest.runUntimedInterruptsTest(0);
    }

    public void testMakeUninterruptible_untimed_interrupted() throws Exception {
        UninterruptibleFutureTest.runUntimedInterruptsTest(1);
    }

    public void testMakeUninterruptible_untimed_multiplyInterrupted() throws Exception {
        UninterruptibleFutureTest.runUntimedInterruptsTest(38);
    }

    public void testMakeUninterruptible_timed_uninterrupted() throws Exception {
        UninterruptibleFutureTest.runTimedInterruptsTest(0);
    }

    public void testMakeUninterruptible_timed_interrupted() throws Exception {
        UninterruptibleFutureTest.runTimedInterruptsTest(1);
    }

    public void testMakeUninterruptible_timed_multiplyInterrupted() throws Exception {
        UninterruptibleFutureTest.runTimedInterruptsTest(38);
    }

    private static void runUntimedInterruptsTest(int times) throws InterruptedException, ExecutionException, TimeoutException {
        SettableFuture future = SettableFuture.create();
        FutureTask<Boolean> interruptReporter = UninterruptibleFutureTest.untimedInterruptReporter(future, false);
        UninterruptibleFutureTest.runNInterruptsTest(times, (SettableFuture<String>)future, interruptReporter);
    }

    private static void runTimedInterruptsTest(int times) throws InterruptedException, ExecutionException, TimeoutException {
        SettableFuture future = SettableFuture.create();
        FutureTask<Boolean> interruptReporter = UninterruptibleFutureTest.timedInterruptReporter(future);
        UninterruptibleFutureTest.runNInterruptsTest(times, (SettableFuture<String>)future, interruptReporter);
    }

    private static void runNInterruptsTest(int times, SettableFuture<String> future, FutureTask<Boolean> interruptReporter) throws InterruptedException, ExecutionException, TimeoutException {
        Thread waitingThread = new Thread(interruptReporter);
        waitingThread.start();
        for (int i = 0; i < times; ++i) {
            waitingThread.interrupt();
        }
        future.set((Object)RESULT);
        UninterruptibleFutureTest.assertEquals((times > 0 ? 1 : 0) != 0, (boolean)interruptReporter.get(20L, TimeUnit.SECONDS));
    }

    public void testMakeUninterruptible_plainFutureSanityCheck() throws Exception {
        SettableFuture future = SettableFuture.create();
        FutureTask<Boolean> wasInterrupted = UninterruptibleFutureTest.untimedInterruptReporter(future, true);
        Thread waitingThread = new Thread(wasInterrupted);
        waitingThread.start();
        waitingThread.interrupt();
        try {
            wasInterrupted.get();
            UninterruptibleFutureTest.fail();
        }
        catch (ExecutionException expected) {
            UninterruptibleFutureTest.assertTrue((String)expected.getCause().toString(), (boolean)(expected.getCause() instanceof InterruptedException));
        }
    }

    public void testMakeUninterruptible_timedGetZeroTimeoutAttempted() throws TimeoutException, ExecutionException {
        SettableFuture future = SettableFuture.create();
        future.set((Object)RESULT);
        UninterruptibleFutureTest.assertEquals((String)RESULT, (String)((String)Uninterruptibles.getUninterruptibly((Future)future, (long)0L, (TimeUnit)TimeUnit.SECONDS)));
    }

    public void testMakeUninterruptible_timedGetNegativeTimeoutAttempted() throws TimeoutException, ExecutionException {
        SettableFuture future = SettableFuture.create();
        future.set((Object)RESULT);
        UninterruptibleFutureTest.assertEquals((String)RESULT, (String)((String)Uninterruptibles.getUninterruptibly((Future)future, (long)-1L, (TimeUnit)TimeUnit.SECONDS)));
    }

    private static FutureTask<Boolean> untimedInterruptReporter(final Future<?> future, final boolean allowInterruption) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Object actual = allowInterruption ? future.get() : Uninterruptibles.getUninterruptibly((Future)future);
                Assert.assertEquals((Object)UninterruptibleFutureTest.RESULT, actual);
                return Thread.interrupted();
            }
        });
    }

    private static FutureTask<Boolean> timedInterruptReporter(final Future<?> future) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Assert.assertEquals((Object)UninterruptibleFutureTest.RESULT, (Object)Uninterruptibles.getUninterruptibly((Future)future, (long)10L, (TimeUnit)TimeUnit.MINUTES));
                return Thread.interrupted();
            }
        });
    }

    private static class SleepingRunnable
    implements Runnable {
        final int millis;
        volatile boolean completed;

        public SleepingRunnable(int millis) {
            this.millis = millis;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException wontHappen) {
                throw new AssertionError();
            }
            this.completed = true;
        }
    }
}

