/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.ConfigurationException;
import com.google.inject.ConstructorInjector;
import com.google.inject.DefaultConstructionProxyFactory;
import com.google.inject.InjectorImpl;
import com.google.inject.MembersInjectorImpl;
import com.google.inject.SingleParameterInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.FailableCache;
import com.google.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, ConstructorInjector<?>> cache = new FailableCache<TypeLiteral<?>, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(type, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> ConstructorInjector<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> ConstructorInjector<T> createConstructor(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        InjectionPoint injectionPoint;
        int numErrorsBefore = errors.size();
        try {
            injectionPoint = InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            throw errors.toException();
        }
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(type, errors);
        DefaultConstructionProxyFactory factory = new DefaultConstructionProxyFactory(injectionPoint);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

