/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.maven;

import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaDataTableRowDumper {
    private static final Log LOG = LogFactory.getLog(MetaDataTableRowDumper.class);

    private MetaDataTableRowDumper() {
    }

    public static void dumpMigrations(List<MetaDataTableRow> metaDataTableRows) {
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        LOG.info((Object)"| Version     | Description            | Installed on        | State   |");
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        if (metaDataTableRows.isEmpty()) {
            LOG.info((Object)"| No migrations applied yet                                            |");
        } else {
            for (MetaDataTableRow metaDataTableRow : metaDataTableRows) {
                LOG.info((Object)("| " + StringUtils.trimOrPad((String)metaDataTableRow.getVersion().toString(), (int)11) + " | " + StringUtils.trimOrPad((String)metaDataTableRow.getDescription(), (int)22) + " | " + StringUtils.trimOrPad((String)MetaDataTableRowDumper.formatInstalledOnDate(metaDataTableRow.getInstalledOn()), (int)19) + " | " + StringUtils.trimOrPad((String)metaDataTableRow.getState().name(), (int)7) + " |"));
            }
        }
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
    }

    private static String formatInstalledOnDate(Date installedOn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(installedOn);
    }
}

