/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.TomcatSetupException;
import java.io.File;
import org.apache.maven.plugin.logging.Log;

public class TomcatDirectorySetup {
    private final File catalinaBaseDir;
    private final Log log;

    public TomcatDirectorySetup(File catalinaBaseDir, Log log) {
        this.catalinaBaseDir = catalinaBaseDir;
        this.log = log;
    }

    public void createTomcatDirectories() {
        if (!this.catalinaBaseDir.exists() && !this.catalinaBaseDir.mkdirs()) {
            throw new TomcatSetupException("could not create 'catalina.base' on " + this.catalinaBaseDir.getAbsolutePath());
        }
        this.createTomcatDirectory("conf");
        this.createTomcatDirectory("webapps");
        this.createTomcatDirectory("lib");
        this.createTomcatDirectory("temp");
        this.createTomcatDirectory("work");
        this.createTomcatDirectory("logs");
    }

    protected void createTomcatDirectory(String name) {
        File directory = new File(this.catalinaBaseDir, name);
        this.log.debug((CharSequence)("Try to create directory " + directory.getAbsolutePath()));
        if (!directory.exists() && !directory.mkdirs()) {
            throw new TomcatSetupException("could not create '" + name + "' on " + directory.getAbsolutePath());
        }
    }
}

