/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jdbcdslog.MySqlRdbmsSpecifics;
import org.jdbcdslog.OracleRdbmsSpecifics;
import org.jdbcdslog.RdbmsSpecifics;
import org.jdbcdslog.SqlServerRdbmsSpecifics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationParameters {
    private static Logger logger = LoggerFactory.getLogger(ConfigurationParameters.class);
    private static Properties props;
    static long slowQueryThreshold;
    static boolean logText;
    static Boolean showTime;
    static boolean printStackTrace;
    static RdbmsSpecifics rdbmsSpecifics;

    private static void initSlowQueryThreshold() {
        String sSlowQueryThreshold = props.getProperty("jdbcdslog.slowQueryThreshold");
        if (sSlowQueryThreshold != null && ConfigurationParameters.isLong(sSlowQueryThreshold)) {
            slowQueryThreshold = Long.parseLong(sSlowQueryThreshold);
        }
        if (slowQueryThreshold == -1L) {
            slowQueryThreshold = Long.MAX_VALUE;
        }
    }

    private static void initLogText() {
        String sLogText = props.getProperty("jdbcdslog.logText", "false");
        if ("true".equalsIgnoreCase(sLogText)) {
            logText = true;
        }
    }

    private static void initPrintStackTrace() {
        String sprintStackTrace = props.getProperty("jdbcdslog.printStackTrace", "false");
        if ("true".equalsIgnoreCase(sprintStackTrace)) {
            printStackTrace = true;
        }
    }

    private static void initShowTime() {
        String isShowTime = props.getProperty("jdbcdslog.showTime", "false");
        if ("true".equalsIgnoreCase(isShowTime)) {
            showTime = true;
        }
    }

    private static void initRdbmsSpecifics() {
        String driverName = props.getProperty("jdbcdslog.driverName");
        if (!"oracle".equalsIgnoreCase(driverName)) {
            if ("mysql".equalsIgnoreCase(driverName)) {
                rdbmsSpecifics = new MySqlRdbmsSpecifics();
            } else if ("sqlserver".equalsIgnoreCase(driverName)) {
                rdbmsSpecifics = new SqlServerRdbmsSpecifics();
            }
        }
    }

    public static void setLogText(boolean alogText) {
        logText = alogText;
    }

    private static boolean isLong(String sSlowQueryThreshold) {
        try {
            Long.parseLong(sSlowQueryThreshold);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        slowQueryThreshold = Long.MAX_VALUE;
        logText = false;
        showTime = false;
        printStackTrace = false;
        rdbmsSpecifics = new OracleRdbmsSpecifics();
        ClassLoader loader = ConfigurationParameters.class.getClassLoader();
        InputStream in = null;
        try {
            in = loader.getResourceAsStream("jdbcdslog.properties");
            props = new Properties(System.getProperties());
            if (in != null) {
                props.load(in);
            }
            ConfigurationParameters.initSlowQueryThreshold();
            ConfigurationParameters.initLogText();
            ConfigurationParameters.initPrintStackTrace();
            ConfigurationParameters.initShowTime();
            ConfigurationParameters.initRdbmsSpecifics();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

