/*
 * Decompiled with CFR 0.152.
 */
package org.jdbcdslog;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdbcdslog.ConfigurationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    static Logger logger = LoggerFactory.getLogger(LogUtils.class);
    private static final String NAMED_PARAMETERS_PREFIX = ":";

    public static void handleException(Throwable e, Logger l, StringBuffer msg) throws Throwable {
        if (e instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)e).getTargetException();
            if (l.isErrorEnabled()) {
                l.error(msg + "\nthrows exception: " + t.getClass().getName() + ": " + t.getMessage(), t);
            }
            throw t;
        }
        if (l.isErrorEnabled()) {
            l.error(msg + "\nthrows exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
        throw e;
    }

    public static StringBuffer createLogEntry(Method method, String sql, TreeMap parameters, TreeMap namedParameters) {
        StringBuffer s = new StringBuffer();
        if (method != null) {
            s.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append(": ");
        }
        if (parameters != null && !parameters.isEmpty()) {
            s.append(LogUtils.createLogEntry(sql, parameters));
        } else {
            s.append(LogUtils.createLogEntryForNamedParameters(sql, namedParameters));
        }
        return s;
    }

    public static StringBuffer createLogEntry(String sql, TreeMap parameters) {
        StringBuffer s = new StringBuffer();
        if (sql != null) {
            int questionMarkCount = 1;
            Pattern p = Pattern.compile("\\?");
            Matcher m = p.matcher(sql);
            StringBuffer stringBuffer = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(stringBuffer, ConfigurationParameters.rdbmsSpecifics.formatParameter(parameters.get(questionMarkCount)));
                ++questionMarkCount;
            }
            sql = String.valueOf(m.appendTail(stringBuffer));
            s.append(sql).append(";");
        }
        return s;
    }

    public static StringBuffer createLogEntryForNamedParameters(String sql, TreeMap namedParameters) {
        StringBuffer s = new StringBuffer();
        if (sql != null) {
            if (namedParameters != null && !namedParameters.isEmpty()) {
                for (String key : namedParameters.keySet()) {
                    sql = sql.replaceAll(NAMED_PARAMETERS_PREFIX + key, ConfigurationParameters.rdbmsSpecifics.formatParameter(namedParameters.get(key)));
                }
            }
            s.append(sql).append(";");
        }
        return s;
    }

    public static String getStackTrace() {
        if (!ConfigurationParameters.printStackTrace) {
            return "";
        }
        StackTraceElement[] stackTraces = new Throwable().getStackTrace();
        StringBuffer sb = new StringBuffer(" at ");
        sb.append(stackTraces[4]);
        return sb.toString();
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        if (text == null || text.length() == 0 || searchList == null || searchList.length == 0 || replacementList == null || replacementList.length == 0) {
            return text;
        }
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        int tempIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (searchList[i] == null || replacementList[i] == null || (greater = replacementList[i].length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append(replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            tempIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i] || searchList[i] == null || searchList[i].length() == 0 || replacementList[i] == null) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        String result = buf.toString();
        return result;
    }
}

