/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.resources;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Stop;
import com.google.protobuf.ByteString;
import com.graphhopper.GraphHopper;
import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.BBox;
import com.wdtinc.mapbox_vector_tile.VectorTile;
import com.wdtinc.mapbox_vector_tile.adapt.jts.IUserDataConverter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import com.wdtinc.mapbox_vector_tile.adapt.jts.TileGeomResult;
import com.wdtinc.mapbox_vector_tile.adapt.jts.UserDataKeyValueMapConverter;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerBuild;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerParams;
import com.wdtinc.mapbox_vector_tile.build.MvtLayerProps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pt-mvt")
@Singleton
public class PtMVTResource {
    private static final Logger logger = LoggerFactory.getLogger(PtMVTResource.class);
    private static final MediaType PBF = new MediaType("application", "x-protobuf");
    private final GraphHopper graphHopper;
    private final GtfsStorage gtfsStorage;
    private final Map<ByteString, MatchResult> openLRCache = new ConcurrentHashMap<ByteString, MatchResult>();
    private final GeometryFactory geometryFactory = new GeometryFactory();

    @Inject
    public PtMVTResource(GraphHopper graphHopper, GtfsStorage gtfsStorage) throws IOException {
        this.graphHopper = graphHopper;
        this.gtfsStorage = gtfsStorage;
    }

    @GET
    @Path(value="{z}/{x}/{y}.mvt")
    @Produces(value={"application/x-protobuf"})
    public Response doGetXyz(@Context HttpServletRequest httpReq, @Context UriInfo uriInfo, @PathParam(value="z") int zInfo, @PathParam(value="x") int xInfo, @PathParam(value="y") int yInfo, @QueryParam(value="details") List<String> pathDetails) {
        Coordinate nw = this.num2deg(xInfo, yInfo, zInfo);
        Coordinate se = this.num2deg(xInfo + 1, yInfo + 1, zInfo);
        BBox bbox = new BBox(nw.x, se.x, se.y, nw.y);
        if (!bbox.isValid()) {
            throw new IllegalStateException("Invalid bbox " + bbox);
        }
        ArrayList<Geometry> features = new ArrayList<Geometry>();
        PtEncodedValues ptEncodedValues = PtEncodedValues.fromEncodingManager((EncodingManager)this.graphHopper.getEncodingManager());
        this.graphHopper.getLocationIndex().query(bbox, edgeId -> {
            EdgeIteratorState edge = this.graphHopper.getGraphHopperStorage().getEdgeIteratorStateForKey(edgeId * 2);
            EdgeIterator i = this.graphHopper.getGraphHopperStorage().createEdgeExplorer().setBaseNode(edge.getBaseNode());
            while (i.next()) {
                if (i.get(ptEncodedValues.getTypeEnc()) != GtfsStorage.EdgeType.EXIT_PT) continue;
                GtfsStorageI.PlatformDescriptor fromPlatformDescriptor = (GtfsStorageI.PlatformDescriptor)this.gtfsStorage.getPlatformDescriptorByEdge().get(i.getEdge());
                Stop stop = (Stop)((GTFSFeed)this.gtfsStorage.getGtfsFeeds().get((Object)fromPlatformDescriptor.feed_id)).stops.get(fromPlatformDescriptor.stop_id);
                HashMap<String, String> properties = new HashMap<String, String>(2);
                properties.put("feed_id", fromPlatformDescriptor.feed_id);
                properties.put("stop_id", fromPlatformDescriptor.stop_id);
                Point feature = this.geometryFactory.createPoint(new Coordinate(stop.stop_lon, stop.stop_lat));
                feature.setUserData(properties);
                features.add((Geometry)feature);
            }
        });
        VectorTile.Tile.Builder mvtBuilder = VectorTile.Tile.newBuilder();
        mvtBuilder.addLayers(this.createLayer(new Envelope(se, nw), new MvtLayerParams(256, 4096), features, "stops"));
        return Response.ok((Object)mvtBuilder.build().toByteArray(), (MediaType)PBF).build();
    }

    private VectorTile.Tile.Layer createLayer(Envelope tileEnvelope, MvtLayerParams layerParams, List<Geometry> locationReferences, String layerName) {
        VectorTile.Tile.Layer.Builder roadsLayerBuilder = MvtLayerBuild.newLayerBuilder((String)layerName, (MvtLayerParams)layerParams);
        TileGeomResult tileGeom = JtsAdapter.createTileGeom(locationReferences, (Envelope)tileEnvelope, (GeometryFactory)this.geometryFactory, (MvtLayerParams)layerParams, geometry -> true);
        MvtLayerProps roadsLayerProps = new MvtLayerProps();
        roadsLayerBuilder.addAllFeatures((Iterable)JtsAdapter.toFeatures((Collection)tileGeom.mvtGeoms, (MvtLayerProps)roadsLayerProps, (IUserDataConverter)new UserDataKeyValueMapConverter()));
        MvtLayerBuild.writeProps((VectorTile.Tile.Layer.Builder)roadsLayerBuilder, (MvtLayerProps)roadsLayerProps);
        return roadsLayerBuilder.build();
    }

    Coordinate num2deg(int xInfo, int yInfo, int zoom) {
        double n = Math.pow(2.0, zoom);
        double lonDeg = (double)xInfo / n * 360.0 - 180.0;
        double latRad = Math.atan(Math.sinh(Math.PI * (1.0 - (double)(2 * yInfo) / n)));
        double latDeg = Math.toDegrees(latRad);
        return new Coordinate(lonDeg, latDeg);
    }
}

