/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithmFactory;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.util.BenchmarkInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ComputationalLaboratory {
    private List<BenchmarkInstance> benchmarkInstances = new ArrayList<BenchmarkInstance>();
    private int runs = 1;
    private Collection<CalculationListener> listeners = new ArrayList<CalculationListener>();
    private Collection<LabStartsAndEndsListener> startsAndEndslisteners = new ArrayList<LabStartsAndEndsListener>();
    private List<Algorithm> algorithms = new ArrayList<Algorithm>();
    private Set<String> algorithmNames = new HashSet<String>();
    private Set<String> instanceNames = new HashSet<String>();
    private int threads = 1;

    public void addAlgorithmFactory(String name, VehicleRoutingAlgorithmFactory factory) {
        if (this.algorithmNames.contains(name)) {
            throw new IllegalStateException("there is already a algorithmFactory with the same name (algorithmName=" + name + "). unique names are required.");
        }
        this.algorithms.add(new Algorithm(name, factory));
        this.algorithmNames.add(name);
    }

    public Collection<String> getAlgorithmNames() {
        return this.algorithmNames;
    }

    public Collection<String> getInstanceNames() {
        return this.instanceNames;
    }

    public void addInstance(String name, VehicleRoutingProblem problem) {
        if (this.benchmarkInstances.contains(name)) {
            throw new IllegalStateException("there is already an instance with the same name (instanceName=" + name + "). unique names are required.");
        }
        this.benchmarkInstances.add(new BenchmarkInstance(name, problem, null, null));
        this.instanceNames.add(name);
    }

    public void addInstance(BenchmarkInstance instance) {
        if (this.benchmarkInstances.contains(instance.name)) {
            throw new IllegalStateException("there is already an instance with the same name (instanceName=" + instance.name + "). unique names are required.");
        }
        this.benchmarkInstances.add(instance);
        this.instanceNames.add(instance.name);
    }

    public void addAllInstances(Collection<BenchmarkInstance> instances) {
        for (BenchmarkInstance i : instances) {
            this.addInstance(i);
        }
    }

    public void addInstance(String name, VehicleRoutingProblem problem, Double bestKnownResult, Double bestKnownVehicles) {
        this.addInstance(new BenchmarkInstance(name, problem, bestKnownResult, bestKnownVehicles));
    }

    public void addListener(LabListener listener) {
        if (listener instanceof CalculationListener) {
            this.listeners.add((CalculationListener)listener);
        }
        if (listener instanceof LabStartsAndEndsListener) {
            this.startsAndEndslisteners.add((LabStartsAndEndsListener)listener);
        }
    }

    public void setNuOfRuns(int runs) {
        this.runs = runs;
    }

    public void run() {
        if (this.algorithms.isEmpty()) {
            throw new IllegalStateException("no algorithm specified. at least one algorithm needs to be specified.");
        }
        if (this.benchmarkInstances.isEmpty()) {
            throw new IllegalStateException("no instance specified. at least one instance needs to be specified.");
        }
        this.informStart();
        System.out.println("start benchmarking [nuAlgorithms=" + this.algorithms.size() + "][nuInstances=" + this.benchmarkInstances.size() + "][runsPerInstance=" + this.runs + "]");
        double startTime = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        for (final Algorithm algorithm : this.algorithms) {
            for (final BenchmarkInstance p : this.benchmarkInstances) {
                int run = 0;
                while (run < this.runs) {
                    final int r = run++;
                    try {
                        executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                ComputationalLaboratory.this.runAlgorithm(p, algorithm, r + 1);
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        try {
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        System.out.println("benchmarking done [time=" + ((double)System.currentTimeMillis() - startTime) / 1000.0 + "sec]");
        this.informEnd();
    }

    private void informEnd() {
        for (LabStartsAndEndsListener l : this.startsAndEndslisteners) {
            l.labEnds();
        }
    }

    private void informStart() {
        for (LabStartsAndEndsListener l : this.startsAndEndslisteners) {
            l.labStarts(this.benchmarkInstances, this.algorithms.size(), this.runs);
        }
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    private void runAlgorithm(BenchmarkInstance p, Algorithm algorithm, int run) {
        System.out.println("[algorithm=" + algorithm.name + "][instance=" + p.name + "][run=" + run + "][status=start]");
        VehicleRoutingAlgorithm vra = algorithm.factory.createAlgorithm(p.vrp);
        this.informCalculationStarts(p, algorithm.name, vra, run);
        Collection solutions = vra.searchSolutions();
        System.out.println("[algorithm=" + algorithm.name + "][instance=" + p.name + "][run=" + run + "][status=finished]");
        this.informCalculationsEnds(p, algorithm.name, vra, run, solutions);
    }

    private void informCalculationStarts(BenchmarkInstance p, String name, VehicleRoutingAlgorithm vra, int run) {
        for (CalculationListener l : this.listeners) {
            l.calculationStarts(p, name, vra, run);
        }
    }

    private void informCalculationsEnds(BenchmarkInstance p, String name, VehicleRoutingAlgorithm vra, int run, Collection<VehicleRoutingProblemSolution> solutions) {
        for (CalculationListener l : this.listeners) {
            l.calculationEnds(p, name, vra, run, solutions);
        }
    }

    private static class Algorithm {
        private String name;
        private VehicleRoutingAlgorithmFactory factory;

        public Algorithm(String name, VehicleRoutingAlgorithmFactory factory) {
            this.name = name;
            this.factory = factory;
        }
    }

    public static class DataCollector {
        private static final String SOLUTION_INDICATOR_NAME = "vehicle-routing-problem-solution";
        private ConcurrentHashMap<Key, Double> data = new ConcurrentHashMap();
        private ConcurrentHashMap<Key, VehicleRoutingProblemSolution> solutions = new ConcurrentHashMap();

        public void addDate(String instanceName, String algorithmName, int run, String indicatorName, double value) {
            if (indicatorName.equals(SOLUTION_INDICATOR_NAME)) {
                throw new IllegalArgumentException(indicatorName + " is already used internally. please choose another indicator-name.");
            }
            Key key = new Key(instanceName, algorithmName, run, indicatorName);
            this.data.put(key, value);
        }

        public void addSolution(String instanceName, String algorithmName, int run, VehicleRoutingProblemSolution solution) {
            Key key = new Key(instanceName, algorithmName, run, SOLUTION_INDICATOR_NAME);
            this.solutions.put(key, solution);
        }

        public Collection<Double> getData(String instanceName, String algorithmName, String indicator) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (Key key : this.data.keySet()) {
                if (!key.getAlgorithmName().equals(algorithmName) || !key.getInstanceName().equals(instanceName) || !key.getIndicatorName().equals(indicator)) continue;
                values.add(this.data.get(key));
            }
            return values;
        }

        public Double getDate(String instanceName, String algorithmName, int run, String indicator) {
            return this.data.get(new Key(instanceName, algorithmName, run, indicator));
        }

        public VehicleRoutingProblemSolution getSolution(String instanceName, String algorithmName, int run) {
            return this.solutions.get(new Key(instanceName, algorithmName, run, "solution"));
        }

        public Set<Key> getDataKeySet() {
            return this.data.keySet();
        }

        public Set<Key> getSolutionKeySet() {
            return this.solutions.keySet();
        }

        public VehicleRoutingProblemSolution getSolution(Key solutionKey) {
            return this.solutions.get(solutionKey);
        }

        public Collection<VehicleRoutingProblemSolution> getSolutions() {
            return this.solutions.values();
        }

        public Double getData(Key key) {
            return this.data.get(key);
        }

        public static class Key {
            private String instanceName;
            private String algorithmName;
            private int run;
            private String indicatorName;

            public Key(String instanceName, String algorithmName, int run, String indicatorName) {
                this.instanceName = instanceName;
                this.algorithmName = algorithmName;
                this.run = run;
                this.indicatorName = indicatorName;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.algorithmName == null ? 0 : this.algorithmName.hashCode());
                result = 31 * result + (this.indicatorName == null ? 0 : this.indicatorName.hashCode());
                result = 31 * result + (this.instanceName == null ? 0 : this.instanceName.hashCode());
                result = 31 * result + this.run;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                if (this.algorithmName == null ? other.algorithmName != null : !this.algorithmName.equals(other.algorithmName)) {
                    return false;
                }
                if (this.indicatorName == null ? other.indicatorName != null : !this.indicatorName.equals(other.indicatorName)) {
                    return false;
                }
                if (this.instanceName == null ? other.instanceName != null : !this.instanceName.equals(other.instanceName)) {
                    return false;
                }
                return this.run == other.run;
            }

            public String getInstanceName() {
                return this.instanceName;
            }

            public String getAlgorithmName() {
                return this.algorithmName;
            }

            public int getRun() {
                return this.run;
            }

            public String getIndicatorName() {
                return this.indicatorName;
            }

            public String toString() {
                return "[algorithm=" + this.algorithmName + "][instance=" + this.instanceName + "][run=" + this.run + "][indicator=" + this.indicatorName + "]";
            }
        }
    }

    public static interface LabStartsAndEndsListener
    extends LabListener {
        public void labStarts(List<BenchmarkInstance> var1, int var2, int var3);

        public void labEnds();
    }

    public static interface CalculationListener
    extends LabListener {
        public void calculationStarts(BenchmarkInstance var1, String var2, VehicleRoutingAlgorithm var3, int var4);

        public void calculationEnds(BenchmarkInstance var1, String var2, VehicleRoutingAlgorithm var3, int var4, Collection<VehicleRoutingProblemSolution> var5);
    }

    public static interface LabListener {
    }
}

