/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.DeliveryActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.PickupActivity;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Time;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.ui.swingViewer.ViewPanel;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.Viewer;

public class GraphStreamViewer {
    public static String STYLESHEET = "node {\tsize: 10px, 10px;   fill-color: #6CC644;\ttext-alignment: at-right; \tstroke-mode: plain;\tstroke-color: #999;\tstroke-width: 1.0;\ttext-font: couriernew; \ttext-offset: 2,-5;\ttext-size: 8;}node.pickup { \tfill-color: #6CC644;}node.delivery { \tfill-color: #f93;}node.pickupInRoute {\tfill-color: #6CC644; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.deliveryInRoute { \tfill-color: #f93; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.depot { \tfill-color: #BD2C00;\tsize: 10px, 10px; \tshape: box;}node.removed { \tfill-color: #BD2C00;\tsize: 10px, 10px; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}edge {\tfill-color: #333;\tarrow-size: 6px,3px;}edge.shipment {\tfill-color: #999;\tarrow-size: 6px,3px;}";
    private Label label = Label.NO_LABEL;
    private long renderDelay_in_ms = 0L;
    private boolean renderShipments = false;
    private Center center;
    private VehicleRoutingProblem vrp;
    private VehicleRoutingProblemSolution solution;
    private double zoomFactor;
    private double scaling = 1.0;

    public static Graph createMultiGraph(String name, String style) {
        MultiGraph g = new MultiGraph(name);
        g.addAttribute("ui.quality", new Object[0]);
        g.addAttribute("ui.antialias", new Object[0]);
        g.addAttribute("ui.stylesheet", new Object[]{style});
        return g;
    }

    public static ViewPanel createEmbeddedView(Graph graph, double scaling) {
        Viewer viewer = new Viewer(graph, Viewer.ThreadingModel.GRAPH_IN_ANOTHER_THREAD);
        ViewPanel view = viewer.addDefaultView(false);
        view.setPreferredSize(new Dimension((int)(698.0 * scaling), (int)(440.0 * scaling)));
        return view;
    }

    public GraphStreamViewer(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
    }

    public GraphStreamViewer(VehicleRoutingProblem vrp, VehicleRoutingProblemSolution solution) {
        this.vrp = vrp;
        this.solution = solution;
    }

    public GraphStreamViewer labelWith(Label label) {
        this.label = label;
        return this;
    }

    public GraphStreamViewer setRenderDelay(long ms) {
        this.renderDelay_in_ms = ms;
        return this;
    }

    public GraphStreamViewer setRenderShipments(boolean renderShipments) {
        this.renderShipments = renderShipments;
        return this;
    }

    public GraphStreamViewer setGraphStreamFrameScalingFactor(double factor) {
        this.scaling = factor;
        return this;
    }

    public GraphStreamViewer setCameraView(double centerX, double centerY, double zoomFactor) {
        this.center = new Center(centerX, centerY);
        this.zoomFactor = zoomFactor;
        return this;
    }

    public void display() {
        System.setProperty("org.graphstream.ui.renderer", "org.graphstream.ui.j2dviewer.J2DGraphRenderer");
        Graph g = this.createMultiGraph("g");
        ViewPanel view = GraphStreamViewer.createEmbeddedView(g, this.scaling);
        this.createJFrame(view, this.scaling);
        this.render(g, view);
    }

    private JFrame createJFrame(ViewPanel view, double scaling) {
        JFrame jframe = new JFrame();
        JPanel basicPanel = new JPanel();
        basicPanel.setLayout(new BoxLayout(basicPanel, 1));
        JPanel resultPanel = this.createResultPanel();
        JPanel graphStreamPanel = new JPanel();
        graphStreamPanel.setPreferredSize(new Dimension((int)(800.0 * scaling), (int)(460.0 * scaling)));
        graphStreamPanel.setBackground(Color.WHITE);
        JPanel graphStreamBackPanel = new JPanel();
        graphStreamBackPanel.setPreferredSize(new Dimension((int)(700.0 * scaling), (int)(450.0 * scaling)));
        graphStreamBackPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        graphStreamBackPanel.setBackground(Color.WHITE);
        graphStreamBackPanel.add((Component)view);
        graphStreamPanel.add(graphStreamBackPanel);
        basicPanel.add(resultPanel);
        basicPanel.add(graphStreamPanel);
        jframe.add(basicPanel);
        jframe.setSize((int)(800.0 * scaling), (int)(580.0 * scaling));
        jframe.setLocationRelativeTo(null);
        jframe.setDefaultCloseOperation(3);
        jframe.setVisible(true);
        jframe.pack();
        jframe.setTitle("jsprit - GraphStream");
        return jframe;
    }

    private Graph createMultiGraph(String name) {
        return GraphStreamViewer.createMultiGraph(name, STYLESHEET);
    }

    private void render(Graph g, ViewPanel view) {
        if (this.center != null) {
            view.resizeFrame(view.getWidth(), view.getHeight());
            this.alignCamera((View)view);
        }
        for (Vehicle vehicle : this.vrp.getVehicles()) {
            this.renderVehicle(g, vehicle, this.label);
            this.sleep(this.renderDelay_in_ms);
        }
        for (Job j : this.vrp.getJobs().values()) {
            if (j instanceof Service) {
                this.renderService(g, (Service)j, this.label);
            } else if (j instanceof Shipment) {
                this.renderShipment(g, (Shipment)j, this.label, this.renderShipments);
            }
            this.sleep(this.renderDelay_in_ms);
        }
        if (this.solution != null) {
            int routeId = 1;
            for (VehicleRoute route : this.solution.getRoutes()) {
                this.renderRoute(g, route, routeId, this.renderDelay_in_ms, this.label);
                this.sleep(this.renderDelay_in_ms);
                ++routeId;
            }
        }
    }

    private void alignCamera(View view) {
        view.getCamera().setViewCenter(this.center.x, this.center.y, 0.0);
        view.getCamera().setViewPercent(this.zoomFactor);
    }

    private JLabel createEmptyLabel() {
        JLabel emptyLabel1 = new JLabel();
        emptyLabel1.setPreferredSize(new Dimension((int)(40.0 * this.scaling), (int)(25.0 * this.scaling)));
        return emptyLabel1;
    }

    private JPanel createResultPanel() {
        int width = 800;
        int height = 50;
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension((int)((double)width * this.scaling), (int)((double)height * this.scaling)));
        panel.setBackground(Color.WHITE);
        JPanel subpanel = new JPanel();
        subpanel.setLayout(new FlowLayout());
        subpanel.setPreferredSize(new Dimension((int)(700.0 * this.scaling), (int)(40.0 * this.scaling)));
        subpanel.setBackground(Color.WHITE);
        subpanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        Font font = Font.decode("couriernew");
        JLabel jobs = new JLabel("jobs");
        jobs.setFont(font);
        jobs.setPreferredSize(new Dimension((int)(40.0 * this.scaling), (int)(25.0 * this.scaling)));
        int noJobs = 0;
        if (this.vrp != null) {
            noJobs = this.vrp.getJobs().values().size();
        }
        JFormattedTextField nJobs = new JFormattedTextField((Object)noJobs);
        nJobs.setFont(font);
        nJobs.setEditable(false);
        nJobs.setBorder(BorderFactory.createEmptyBorder());
        nJobs.setBackground(new Color(230, 230, 230));
        JLabel costs = new JLabel("costs");
        costs.setFont(font);
        costs.setPreferredSize(new Dimension((int)(40.0 * this.scaling), (int)(25.0 * this.scaling)));
        JFormattedTextField costsVal = new JFormattedTextField(this.getSolutionCosts());
        costsVal.setFont(font);
        costsVal.setEditable(false);
        costsVal.setBorder(BorderFactory.createEmptyBorder());
        costsVal.setBackground(new Color(230, 230, 230));
        JLabel vehicles = new JLabel("routes");
        vehicles.setFont(font);
        vehicles.setPreferredSize(new Dimension((int)(40.0 * this.scaling), (int)(25.0 * this.scaling)));
        JFormattedTextField vehVal = new JFormattedTextField(this.getNoRoutes());
        vehVal.setFont(font);
        vehVal.setEditable(false);
        vehVal.setBorder(BorderFactory.createEmptyBorder());
        vehVal.setBackground(new Color(230, 230, 230));
        JLabel placeholder1 = new JLabel();
        placeholder1.setPreferredSize(new Dimension((int)(60.0 * this.scaling), (int)(25.0 * this.scaling)));
        JLabel emptyLabel1 = this.createEmptyLabel();
        subpanel.add(jobs);
        subpanel.add(nJobs);
        subpanel.add(emptyLabel1);
        subpanel.add(costs);
        subpanel.add(costsVal);
        JLabel emptyLabel2 = this.createEmptyLabel();
        subpanel.add(emptyLabel2);
        subpanel.add(vehicles);
        subpanel.add(vehVal);
        panel.add(subpanel);
        return panel;
    }

    private Integer getNoRoutes() {
        if (this.solution != null) {
            return this.solution.getRoutes().size();
        }
        return 0;
    }

    private Double getSolutionCosts() {
        if (this.solution != null) {
            return this.solution.getCost();
        }
        return 0.0;
    }

    private void renderShipment(Graph g, Shipment shipment, Label label, boolean renderShipments) {
        Node n1 = g.addNode(this.makeId(shipment.getId(), shipment.getPickupLocation().getId()));
        if (label.equals((Object)Label.ID)) {
            n1.addAttribute("ui.label", new Object[]{shipment.getId()});
        }
        n1.addAttribute("x", new Object[]{shipment.getPickupLocation().getCoordinate().getX()});
        n1.addAttribute("y", new Object[]{shipment.getPickupLocation().getCoordinate().getY()});
        n1.setAttribute("ui.class", new Object[]{"pickup"});
        Node n2 = g.addNode(this.makeId(shipment.getId(), shipment.getDeliveryLocation().getId()));
        if (label.equals((Object)Label.ID)) {
            n2.addAttribute("ui.label", new Object[]{shipment.getId()});
        }
        n2.addAttribute("x", new Object[]{shipment.getDeliveryLocation().getCoordinate().getX()});
        n2.addAttribute("y", new Object[]{shipment.getDeliveryLocation().getCoordinate().getY()});
        n2.setAttribute("ui.class", new Object[]{"delivery"});
        if (renderShipments) {
            Edge s = g.addEdge(shipment.getId(), this.makeId(shipment.getId(), shipment.getPickupLocation().getId()), this.makeId(shipment.getId(), shipment.getDeliveryLocation().getId()), true);
            s.addAttribute("ui.class", new Object[]{"shipment"});
        }
    }

    private void sleep(long renderDelay_in_ms2) {
        try {
            Thread.sleep(renderDelay_in_ms2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void renderService(Graph g, Service service, Label label) {
        Node n = g.addNode(this.makeId(service.getId(), service.getLocation().getId()));
        if (label.equals((Object)Label.ID)) {
            n.addAttribute("ui.label", new Object[]{service.getId()});
        }
        n.addAttribute("x", new Object[]{service.getLocation().getCoordinate().getX()});
        n.addAttribute("y", new Object[]{service.getLocation().getCoordinate().getY()});
        if (service.getType().equals("pickup")) {
            n.setAttribute("ui.class", new Object[]{"pickup"});
        }
        if (service.getType().equals("delivery")) {
            n.setAttribute("ui.class", new Object[]{"delivery"});
        }
    }

    private String makeId(String id, String locationId) {
        return id + "_" + locationId;
    }

    private void renderVehicle(Graph g, Vehicle vehicle, Label label) {
        String nodeId = this.makeId(vehicle.getId(), vehicle.getStartLocation().getId());
        Node vehicleStart = g.addNode(nodeId);
        if (label.equals((Object)Label.ID)) {
            vehicleStart.addAttribute("ui.label", new Object[]{"depot"});
        }
        vehicleStart.addAttribute("x", new Object[]{vehicle.getStartLocation().getCoordinate().getX()});
        vehicleStart.addAttribute("y", new Object[]{vehicle.getStartLocation().getCoordinate().getY()});
        vehicleStart.setAttribute("ui.class", new Object[]{"depot"});
        if (!vehicle.getStartLocation().getId().equals(vehicle.getEndLocation().getId())) {
            Node vehicleEnd = g.addNode(this.makeId(vehicle.getId(), vehicle.getEndLocation().getId()));
            if (label.equals((Object)Label.ID)) {
                vehicleEnd.addAttribute("ui.label", new Object[]{"depot"});
            }
            vehicleEnd.addAttribute("x", new Object[]{vehicle.getEndLocation().getCoordinate().getX()});
            vehicleEnd.addAttribute("y", new Object[]{vehicle.getEndLocation().getCoordinate().getY()});
            vehicleEnd.setAttribute("ui.class", new Object[]{"depot"});
        }
    }

    private void renderRoute(Graph g, VehicleRoute route, int routeId, long renderDelay_in_ms, Label label) {
        int vehicle_edgeId = 1;
        String prevIdentifier = this.makeId(route.getVehicle().getId(), route.getVehicle().getStartLocation().getId());
        if (label.equals((Object)Label.ACTIVITY) || label.equals((Object)Label.JOB_NAME)) {
            Node n = g.getNode(prevIdentifier);
            n.addAttribute("ui.label", new Object[]{"start"});
        }
        for (TourActivity act : route.getActivities()) {
            Node actNode;
            Job job = ((TourActivity.JobActivity)act).getJob();
            String currIdentifier = this.makeId(job.getId(), act.getLocation().getId());
            if (label.equals((Object)Label.ACTIVITY)) {
                actNode = g.getNode(currIdentifier);
                actNode.addAttribute("ui.label", new Object[]{act.getName()});
            } else if (label.equals((Object)Label.JOB_NAME)) {
                actNode = g.getNode(currIdentifier);
                actNode.addAttribute("ui.label", new Object[]{job.getName()});
            } else if (label.equals((Object)Label.ARRIVAL_TIME)) {
                actNode = g.getNode(currIdentifier);
                actNode.addAttribute("ui.label", new Object[]{Time.parseSecondsToTime((double)act.getArrTime())});
            } else if (label.equals((Object)Label.DEPARTURE_TIME)) {
                actNode = g.getNode(currIdentifier);
                actNode.addAttribute("ui.label", new Object[]{Time.parseSecondsToTime((double)act.getEndTime())});
            }
            g.addEdge(this.makeEdgeId(routeId, vehicle_edgeId), prevIdentifier, currIdentifier, true);
            if (act instanceof PickupActivity) {
                g.getNode(currIdentifier).addAttribute("ui.class", new Object[]{"pickupInRoute"});
            } else if (act instanceof DeliveryActivity) {
                g.getNode(currIdentifier).addAttribute("ui.class", new Object[]{"deliveryInRoute"});
            }
            prevIdentifier = currIdentifier;
            ++vehicle_edgeId;
            this.sleep(renderDelay_in_ms);
        }
        if (route.getVehicle().isReturnToDepot()) {
            String lastIdentifier = this.makeId(route.getVehicle().getId(), route.getVehicle().getEndLocation().getId());
            g.addEdge(this.makeEdgeId(routeId, vehicle_edgeId), prevIdentifier, lastIdentifier, true);
        }
    }

    private String makeEdgeId(int routeId, int vehicle_edgeId) {
        return Integer.valueOf(routeId).toString() + "." + Integer.valueOf(vehicle_edgeId).toString();
    }

    private static class Center {
        final double x;
        final double y;

        public Center(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum Label {
        NO_LABEL,
        ID,
        JOB_NAME,
        ARRIVAL_TIME,
        DEPARTURE_TIME,
        ACTIVITY;

    }

    public static class StyleSheets {
        public static String BLUE_FOREST = "graph { fill-color: #141F2E; }node {\tsize: 7px, 7px;   fill-color: #A0FFA0;\ttext-alignment: at-right; \tstroke-mode: plain;\tstroke-color: #999;\tstroke-width: 1.0;\ttext-font: couriernew; \ttext-offset: 2,-5;\ttext-size: 8;}node.pickup { \tfill-color: #6CC644;}node.delivery { \tfill-color: #f93;}node.pickupInRoute {\tfill-color: #6CC644; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.deliveryInRoute { \tfill-color: #f93; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.depot { \tfill-color: #BD2C00;\tsize: 10px, 10px; \tshape: box;}node.removed { \tfill-color: #FF8080;\tsize: 10px, 10px; \tstroke-mode: plain;\tstroke-color: #CCF;   stroke-width: 2.0;   shadow-mode: gradient-radial;   shadow-width: 10px; shadow-color: #EEF, #000; shadow-offset: 0px;}edge {\tfill-color: #D3D3D3;\tarrow-size: 6px,3px;}edge.shipment {\tfill-color: #999;\tarrow-size: 6px,3px;}";
        public static String SIMPLE_WHITE = "node {\tsize: 10px, 10px;   fill-color: #6CC644;\ttext-alignment: at-right; \tstroke-mode: plain;\tstroke-color: #999;\tstroke-width: 1.0;\ttext-font: couriernew; \ttext-offset: 2,-5;\ttext-size: 8;}node.pickup { \tfill-color: #6CC644;}node.delivery { \tfill-color: #f93;}node.pickupInRoute {\tfill-color: #6CC644; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.deliveryInRoute { \tfill-color: #f93; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}node.depot { \tfill-color: #BD2C00;\tsize: 10px, 10px; \tshape: box;}node.removed { \tfill-color: #BD2C00;\tsize: 10px, 10px; \tstroke-mode: plain;\tstroke-color: #333;   stroke-width: 2.0;}edge {\tfill-color: #333;\tarrow-size: 6px,3px;}edge.shipment {\tfill-color: #999;\tarrow-size: 6px,3px;}";
    }
}

