/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.analysis.toolbox.NoLocationFoundException;
import com.graphhopper.jsprit.core.problem.Location;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.job.Delivery;
import com.graphhopper.jsprit.core.problem.job.Job;
import com.graphhopper.jsprit.core.problem.job.Pickup;
import com.graphhopper.jsprit.core.problem.job.Service;
import com.graphhopper.jsprit.core.problem.job.Shipment;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import com.graphhopper.jsprit.core.problem.solution.route.VehicleRoute;
import com.graphhopper.jsprit.core.problem.solution.route.activity.TourActivity;
import com.graphhopper.jsprit.core.problem.vehicle.Vehicle;
import com.graphhopper.jsprit.core.util.Coordinate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ShapeUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plotter {
    private static final Color START_COLOR = Color.RED;
    private static final Color END_COLOR = Color.RED;
    private static final Color PICKUP_COLOR = Color.GREEN;
    private static final Color DELIVERY_COLOR = Color.BLUE;
    private static final Color SERVICE_COLOR = Color.BLUE;
    private static final Shape ELLIPSE = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
    private static Logger log = LoggerFactory.getLogger(Plotter.class);
    private Label label = Label.SIZE;
    private VehicleRoutingProblem vrp;
    private boolean plotSolutionAsWell = false;
    private boolean plotShipments = true;
    private Collection<VehicleRoute> routes;
    private BoundingBox boundingBox = null;
    private Map<XYDataItem, Activity> activitiesByDataItem = new HashMap<XYDataItem, Activity>();
    private Map<XYDataItem, String> labelsByDataItem = new HashMap<XYDataItem, String>();
    private XYSeries activities;
    private Set<XYDataItem> firstActivities = new HashSet<XYDataItem>();
    private boolean containsPickupAct = false;
    private boolean containsDeliveryAct = false;
    private boolean containsServiceAct = false;
    private double scalingFactor = 1.0;
    private boolean invert = false;

    public Plotter(VehicleRoutingProblem vrp) {
        this.vrp = vrp;
    }

    public Plotter(VehicleRoutingProblem vrp, VehicleRoutingProblemSolution solution) {
        this.vrp = vrp;
        this.routes = solution.getRoutes();
        this.plotSolutionAsWell = true;
    }

    public Plotter(VehicleRoutingProblem vrp, Collection<VehicleRoute> routes) {
        this.vrp = vrp;
        this.routes = routes;
        this.plotSolutionAsWell = true;
    }

    public Plotter setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
        return this;
    }

    public Plotter setLabel(Label label) {
        this.label = label;
        return this;
    }

    public Plotter invertCoordinates(boolean invert) {
        this.invert = invert;
        return this;
    }

    public Plotter setBoundingBox(double minX, double minY, double maxX, double maxY) {
        this.boundingBox = new BoundingBox(minX, minY, maxX, maxY);
        return this;
    }

    public Plotter plotShipments(boolean plotShipments) {
        this.plotShipments = plotShipments;
        return this;
    }

    public void plot(String pngFileName, String plotTitle) {
        String filename = pngFileName;
        if (!pngFileName.endsWith(".png")) {
            filename = filename + ".png";
        }
        if (this.plotSolutionAsWell) {
            this.plot(this.vrp, this.routes, filename, plotTitle);
        } else if (!this.vrp.getInitialVehicleRoutes().isEmpty()) {
            this.plot(this.vrp, this.vrp.getInitialVehicleRoutes(), filename, plotTitle);
        } else {
            this.plot(this.vrp, null, filename, plotTitle);
        }
    }

    private void plot(VehicleRoutingProblem vrp, Collection<VehicleRoute> routes, String pngFile, String title) {
        XYSeriesCollection shipments;
        XYSeriesCollection problem;
        log.info("plot to {}", (Object)pngFile);
        XYSeriesCollection solution = null;
        try {
            this.retrieveActivities(vrp);
            problem = new XYSeriesCollection(this.activities);
            shipments = this.makeShipmentSeries(vrp.getJobs().values());
            if (routes != null) {
                solution = this.makeSolutionSeries(vrp, routes);
            }
        }
        catch (NoLocationFoundException e) {
            log.warn("cannot plot vrp, since coord is missing");
            return;
        }
        XYPlot plot = this.createPlot(problem, shipments, solution);
        JFreeChart chart = new JFreeChart(title, (Plot)plot);
        LegendTitle legend = this.createLegend(routes, shipments, plot);
        chart.removeLegend();
        chart.addLegend(legend);
        this.save(chart, pngFile);
    }

    private LegendTitle createLegend(final Collection<VehicleRoute> routes, final XYSeriesCollection shipments, final XYPlot plot) {
        LegendItemSource lis = new LegendItemSource(){

            public LegendItemCollection getLegendItems() {
                LegendItem item;
                LegendItemCollection lic = new LegendItemCollection();
                LegendItem vehLoc = new LegendItem("vehLoc", (Paint)Color.RED);
                vehLoc.setShape(ELLIPSE);
                vehLoc.setShapeVisible(true);
                lic.add(vehLoc);
                if (Plotter.this.containsServiceAct) {
                    item = new LegendItem("service", (Paint)Color.BLUE);
                    item.setShape(ELLIPSE);
                    item.setShapeVisible(true);
                    lic.add(item);
                }
                if (Plotter.this.containsPickupAct) {
                    item = new LegendItem("pickup", (Paint)Color.GREEN);
                    item.setShape(ELLIPSE);
                    item.setShapeVisible(true);
                    lic.add(item);
                }
                if (Plotter.this.containsDeliveryAct) {
                    item = new LegendItem("delivery", (Paint)Color.BLUE);
                    item.setShape(ELLIPSE);
                    item.setShapeVisible(true);
                    lic.add(item);
                }
                if (routes != null) {
                    item = new LegendItem("firstActivity", (Paint)Color.BLACK);
                    Shape upTriangle = ShapeUtilities.createUpTriangle((float)3.0f);
                    item.setShape(upTriangle);
                    item.setOutlinePaint((Paint)Color.BLACK);
                    item.setLine(upTriangle);
                    item.setLinePaint((Paint)Color.BLACK);
                    item.setShapeVisible(true);
                    lic.add(item);
                }
                if (!shipments.getSeries().isEmpty()) {
                    lic.add(plot.getRenderer(1).getLegendItem(1, 0));
                }
                if (routes != null) {
                    lic.addAll(plot.getRenderer(2).getLegendItems());
                }
                return lic;
            }
        };
        LegendTitle legend = new LegendTitle(lis);
        legend.setPosition(RectangleEdge.BOTTOM);
        return legend;
    }

    private XYItemRenderer getShipmentRenderer(XYSeriesCollection shipments) {
        XYLineAndShapeRenderer shipmentsRenderer = new XYLineAndShapeRenderer(true, false);
        for (int i = 0; i < shipments.getSeriesCount(); ++i) {
            shipmentsRenderer.setSeriesPaint(i, (Paint)Color.DARK_GRAY);
            shipmentsRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f));
        }
        return shipmentsRenderer;
    }

    private MyActivityRenderer getProblemRenderer(final XYSeriesCollection problem) {
        MyActivityRenderer problemRenderer = new MyActivityRenderer(problem, this.activitiesByDataItem, this.firstActivities);
        problemRenderer.setBaseItemLabelGenerator(new XYItemLabelGenerator(){

            public String generateLabel(XYDataset arg0, int arg1, int arg2) {
                XYDataItem item = problem.getSeries(arg1).getDataItem(arg2);
                return (String)Plotter.this.labelsByDataItem.get(item);
            }
        });
        problemRenderer.setBaseItemLabelsVisible(true);
        problemRenderer.setBaseItemLabelPaint(Color.BLACK);
        return problemRenderer;
    }

    private Range getRange(XYSeriesCollection seriesCol) {
        if (this.boundingBox == null) {
            return seriesCol.getRangeBounds(false);
        }
        return new Range(this.boundingBox.minY, this.boundingBox.maxY);
    }

    private Range getDomainRange(XYSeriesCollection seriesCol) {
        if (this.boundingBox == null) {
            return seriesCol.getDomainBounds(true);
        }
        return new Range(this.boundingBox.minX, this.boundingBox.maxX);
    }

    private XYPlot createPlot(XYSeriesCollection problem, XYSeriesCollection shipments, XYSeriesCollection solution) {
        XYPlot plot = new XYPlot();
        plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        MyActivityRenderer problemRenderer = this.getProblemRenderer(problem);
        plot.setDataset(0, (XYDataset)problem);
        plot.setRenderer(0, (XYItemRenderer)problemRenderer);
        XYItemRenderer shipmentsRenderer = this.getShipmentRenderer(shipments);
        plot.setDataset(1, (XYDataset)shipments);
        plot.setRenderer(1, shipmentsRenderer);
        if (solution != null) {
            XYItemRenderer solutionRenderer = this.getRouteRenderer(solution);
            plot.setDataset(2, (XYDataset)solution);
            plot.setRenderer(2, solutionRenderer);
        }
        NumberAxis xAxis = new NumberAxis();
        NumberAxis yAxis = new NumberAxis();
        if (this.boundingBox == null) {
            xAxis.setRangeWithMargins(this.getDomainRange(problem));
            yAxis.setRangeWithMargins(this.getRange(problem));
        } else {
            xAxis.setRangeWithMargins(new Range(this.boundingBox.minX, this.boundingBox.maxX));
            yAxis.setRangeWithMargins(new Range(this.boundingBox.minY, this.boundingBox.maxY));
        }
        plot.setDomainAxis((ValueAxis)xAxis);
        plot.setRangeAxis((ValueAxis)yAxis);
        return plot;
    }

    private XYItemRenderer getRouteRenderer(XYSeriesCollection solutionColl) {
        XYLineAndShapeRenderer solutionRenderer = new XYLineAndShapeRenderer(true, false);
        for (int i = 0; i < solutionColl.getSeriesCount(); ++i) {
            XYSeries s = solutionColl.getSeries(i);
            XYDataItem firstCustomer = s.getDataItem(1);
            this.firstActivities.add(firstCustomer);
        }
        return solutionRenderer;
    }

    private void save(JFreeChart chart, String pngFile) {
        try {
            ChartUtilities.saveChartAsPNG((File)new File(pngFile), (JFreeChart)chart, (int)1000, (int)600);
        }
        catch (IOException e) {
            log.error("cannot plot");
            log.error(e.toString());
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private XYSeriesCollection makeSolutionSeries(VehicleRoutingProblem vrp, Collection<VehicleRoute> routes) throws NoLocationFoundException {
        Map<String, Coordinate> coords = this.makeMap(vrp.getAllLocations());
        XYSeriesCollection coll = new XYSeriesCollection();
        int counter = 1;
        for (VehicleRoute route : routes) {
            if (route.isEmpty()) continue;
            XYSeries series = new XYSeries((Comparable)Integer.valueOf(counter), false, true);
            Coordinate startCoord = this.getCoordinate(coords.get(route.getStart().getLocation().getId()));
            series.add(startCoord.getX() * this.scalingFactor, startCoord.getY() * this.scalingFactor);
            for (TourActivity act : route.getTourActivities().getActivities()) {
                Coordinate coord = this.getCoordinate(coords.get(act.getLocation().getId()));
                series.add(coord.getX() * this.scalingFactor, coord.getY() * this.scalingFactor);
            }
            Coordinate endCoord = this.getCoordinate(coords.get(route.getEnd().getLocation().getId()));
            series.add(endCoord.getX() * this.scalingFactor, endCoord.getY() * this.scalingFactor);
            coll.addSeries(series);
            ++counter;
        }
        return coll;
    }

    private Map<String, Coordinate> makeMap(Collection<Location> allLocations) {
        HashMap<String, Coordinate> coords = new HashMap<String, Coordinate>();
        for (Location l : allLocations) {
            coords.put(l.getId(), l.getCoordinate());
        }
        return coords;
    }

    private XYSeriesCollection makeShipmentSeries(Collection<Job> jobs) throws NoLocationFoundException {
        XYSeriesCollection coll = new XYSeriesCollection();
        if (!this.plotShipments) {
            return coll;
        }
        int sCounter = 1;
        String ship = "shipment";
        boolean first = true;
        for (Job job : jobs) {
            XYSeries shipmentSeries;
            if (!(job instanceof Shipment)) continue;
            Shipment shipment = (Shipment)job;
            if (first) {
                first = false;
                shipmentSeries = new XYSeries((Comparable)((Object)ship), false, true);
            } else {
                shipmentSeries = new XYSeries((Comparable)Integer.valueOf(sCounter), false, true);
                ++sCounter;
            }
            Coordinate pickupCoordinate = this.getCoordinate(shipment.getPickupLocation().getCoordinate());
            Coordinate delCoordinate = this.getCoordinate(shipment.getDeliveryLocation().getCoordinate());
            shipmentSeries.add(pickupCoordinate.getX() * this.scalingFactor, pickupCoordinate.getY() * this.scalingFactor);
            shipmentSeries.add(delCoordinate.getX() * this.scalingFactor, delCoordinate.getY() * this.scalingFactor);
            coll.addSeries(shipmentSeries);
        }
        return coll;
    }

    private void addJob(XYSeries activities, Job job) {
        if (job instanceof Shipment) {
            Shipment s = (Shipment)job;
            Coordinate pickupCoordinate = this.getCoordinate(s.getPickupLocation().getCoordinate());
            XYDataItem dataItem = new XYDataItem(pickupCoordinate.getX() * this.scalingFactor, pickupCoordinate.getY() * this.scalingFactor);
            activities.add(dataItem);
            this.addLabel((Job)s, dataItem);
            this.markItem(dataItem, Activity.PICKUP);
            this.containsPickupAct = true;
            Coordinate deliveryCoordinate = this.getCoordinate(s.getDeliveryLocation().getCoordinate());
            XYDataItem dataItem2 = new XYDataItem(deliveryCoordinate.getX() * this.scalingFactor, deliveryCoordinate.getY() * this.scalingFactor);
            activities.add(dataItem2);
            this.addLabel((Job)s, dataItem2);
            this.markItem(dataItem2, Activity.DELIVERY);
            this.containsDeliveryAct = true;
        } else if (job instanceof Pickup) {
            Pickup service = (Pickup)job;
            Coordinate coord = this.getCoordinate(service.getLocation().getCoordinate());
            XYDataItem dataItem = new XYDataItem(coord.getX() * this.scalingFactor, coord.getY() * this.scalingFactor);
            activities.add(dataItem);
            this.addLabel((Job)service, dataItem);
            this.markItem(dataItem, Activity.PICKUP);
            this.containsPickupAct = true;
        } else if (job instanceof Delivery) {
            Delivery service = (Delivery)job;
            Coordinate coord = this.getCoordinate(service.getLocation().getCoordinate());
            XYDataItem dataItem = new XYDataItem(coord.getX() * this.scalingFactor, coord.getY() * this.scalingFactor);
            activities.add(dataItem);
            this.addLabel((Job)service, dataItem);
            this.markItem(dataItem, Activity.DELIVERY);
            this.containsDeliveryAct = true;
        } else if (job instanceof Service) {
            Service service = (Service)job;
            Coordinate coord = this.getCoordinate(service.getLocation().getCoordinate());
            XYDataItem dataItem = new XYDataItem(coord.getX() * this.scalingFactor, coord.getY() * this.scalingFactor);
            activities.add(dataItem);
            this.addLabel((Job)service, dataItem);
            this.markItem(dataItem, Activity.SERVICE);
            this.containsServiceAct = true;
        } else {
            throw new IllegalStateException("job instanceof " + job.getClass().toString() + ". this is not supported.");
        }
    }

    private void addLabel(Job job, XYDataItem dataItem) {
        if (this.label.equals((Object)Label.SIZE)) {
            this.labelsByDataItem.put(dataItem, this.getSizeString(job));
        } else if (this.label.equals((Object)Label.ID)) {
            this.labelsByDataItem.put(dataItem, String.valueOf(job.getId()));
        }
    }

    private String getSizeString(Job job) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean firstDim = true;
        for (int i = 0; i < job.getSize().getNuOfDimensions(); ++i) {
            if (firstDim) {
                builder.append(String.valueOf(job.getSize().get(i)));
                firstDim = false;
                continue;
            }
            builder.append(",");
            builder.append(String.valueOf(job.getSize().get(i)));
        }
        builder.append(")");
        return builder.toString();
    }

    private Coordinate getCoordinate(Coordinate coordinate) {
        if (this.invert) {
            return Coordinate.newInstance((double)coordinate.getY(), (double)coordinate.getX());
        }
        return coordinate;
    }

    private void retrieveActivities(VehicleRoutingProblem vrp) throws NoLocationFoundException {
        this.activities = new XYSeries((Comparable)((Object)"activities"), false, true);
        for (Vehicle v : vrp.getVehicles()) {
            Coordinate start_coordinate = this.getCoordinate(v.getStartLocation().getCoordinate());
            if (start_coordinate == null) {
                throw new NoLocationFoundException();
            }
            XYDataItem item = new XYDataItem(start_coordinate.getX() * this.scalingFactor, start_coordinate.getY() * this.scalingFactor);
            this.markItem(item, Activity.START);
            this.activities.add(item);
            if (v.getStartLocation().getId().equals(v.getEndLocation().getId())) continue;
            Coordinate end_coordinate = this.getCoordinate(v.getEndLocation().getCoordinate());
            if (end_coordinate == null) {
                throw new NoLocationFoundException();
            }
            XYDataItem end_item = new XYDataItem(end_coordinate.getX() * this.scalingFactor, end_coordinate.getY() * this.scalingFactor);
            this.markItem(end_item, Activity.END);
            this.activities.add(end_item);
        }
        for (Job job : vrp.getJobs().values()) {
            this.addJob(this.activities, job);
        }
        for (VehicleRoute r : vrp.getInitialVehicleRoutes()) {
            for (Job job : r.getTourActivities().getJobs()) {
                this.addJob(this.activities, job);
            }
        }
    }

    private void markItem(XYDataItem item, Activity activity) {
        this.activitiesByDataItem.put(item, activity);
    }

    public static enum Label {
        ID,
        SIZE,
        NO_LABEL;

    }

    private static enum Activity {
        START,
        END,
        PICKUP,
        DELIVERY,
        SERVICE;

    }

    private static class BoundingBox {
        double minX;
        double minY;
        double maxX;
        double maxY;

        public BoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    private static class MyActivityRenderer
    extends XYLineAndShapeRenderer {
        private static final long serialVersionUID = 1L;
        private XYSeriesCollection seriesCollection;
        private Map<XYDataItem, Activity> activities;
        private Set<XYDataItem> firstActivities;

        public MyActivityRenderer(XYSeriesCollection seriesCollection, Map<XYDataItem, Activity> activities, Set<XYDataItem> firstActivities) {
            super(false, true);
            this.seriesCollection = seriesCollection;
            this.activities = activities;
            this.firstActivities = firstActivities;
            super.setSeriesOutlinePaint(0, (Paint)Color.DARK_GRAY);
            super.setUseOutlinePaint(true);
        }

        public Shape getItemShape(int seriesIndex, int itemIndex) {
            XYDataItem dataItem = this.seriesCollection.getSeries(seriesIndex).getDataItem(itemIndex);
            if (this.firstActivities.contains(dataItem)) {
                return ShapeUtilities.createUpTriangle((float)4.0f);
            }
            return ELLIPSE;
        }

        public Paint getItemOutlinePaint(int seriesIndex, int itemIndex) {
            XYDataItem dataItem = this.seriesCollection.getSeries(seriesIndex).getDataItem(itemIndex);
            if (this.firstActivities.contains(dataItem)) {
                return Color.BLACK;
            }
            return super.getItemOutlinePaint(seriesIndex, itemIndex);
        }

        public Paint getItemPaint(int seriesIndex, int itemIndex) {
            XYDataItem dataItem = this.seriesCollection.getSeries(seriesIndex).getDataItem(itemIndex);
            Activity activity = this.activities.get(dataItem);
            if (activity.equals((Object)Activity.PICKUP)) {
                return PICKUP_COLOR;
            }
            if (activity.equals((Object)Activity.DELIVERY)) {
                return DELIVERY_COLOR;
            }
            if (activity.equals((Object)Activity.SERVICE)) {
                return SERVICE_COLOR;
            }
            if (activity.equals((Object)Activity.START)) {
                return START_COLOR;
            }
            if (activity.equals((Object)Activity.END)) {
                return END_COLOR;
            }
            throw new IllegalStateException("activity at " + dataItem.toString() + " cannot be assigned to a color");
        }
    }
}

