/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.toolbox;

import com.graphhopper.jsprit.core.algorithm.VehicleRoutingAlgorithm;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmEndsListener;
import com.graphhopper.jsprit.core.algorithm.listener.AlgorithmStartsListener;
import com.graphhopper.jsprit.core.problem.VehicleRoutingProblem;
import com.graphhopper.jsprit.core.problem.solution.VehicleRoutingProblemSolution;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWatch
implements AlgorithmStartsListener,
AlgorithmEndsListener {
    private static Logger log = LoggerFactory.getLogger(StopWatch.class);
    private double ran;
    private double startTime;

    public void informAlgorithmStarts(VehicleRoutingProblem problem, VehicleRoutingAlgorithm algorithm, Collection<VehicleRoutingProblemSolution> solutions) {
        this.reset();
        this.start();
    }

    public double getCompTimeInSeconds() {
        return this.ran / 1000.0;
    }

    public void informAlgorithmEnds(VehicleRoutingProblem problem, Collection<VehicleRoutingProblemSolution> solutions) {
        this.stop();
        log.info("computation time [in sec]: {}", (Object)this.getCompTimeInSeconds());
    }

    public void stop() {
        this.ran += (double)System.currentTimeMillis() - this.startTime;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void reset() {
        this.startTime = 0.0;
        this.ran = 0.0;
    }

    public String toString() {
        return "stopWatch: " + this.getCompTimeInSeconds() + " sec";
    }

    public double getCurrTimeInSeconds() {
        return ((double)System.currentTimeMillis() - this.startTime) / 1000.0;
    }
}

