/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jsprit.analysis.util;

import com.graphhopper.jsprit.analysis.util.BenchmarkWriter;
import com.graphhopper.jsprit.core.util.BenchmarkResult;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;

public class HtmlBenchmarkTableWriter
implements BenchmarkWriter {
    private String filename;

    public HtmlBenchmarkTableWriter(String filename) {
        this.filename = filename;
    }

    @Override
    public void write(Collection<BenchmarkResult> results) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.filename)));
            writer.write(this.openTable() + this.newline());
            writer.write(this.openRow() + this.newline());
            writer.write(this.head("inst") + this.newline());
            writer.write(this.head("runs") + this.newline());
            writer.write(this.head("&Oslash; time [sec]") + this.newline());
            writer.write(this.head("results", 4));
            writer.write(this.head("vehicles", 4));
            writer.write(this.head("res*") + this.newline());
            writer.write(this.head("veh*") + this.newline());
            writer.write(this.closeRow() + this.newline());
            writer.write(this.openRow() + this.newline());
            writer.write(this.head("") + this.newline());
            writer.write(this.head("") + this.newline());
            writer.write(this.head("") + this.newline());
            writer.write(this.head("best") + this.newline());
            writer.write(this.head("avg") + this.newline());
            writer.write(this.head("worst") + this.newline());
            writer.write(this.head("stdev") + this.newline());
            writer.write(this.head("best") + this.newline());
            writer.write(this.head("avg") + this.newline());
            writer.write(this.head("worst") + this.newline());
            writer.write(this.head("stdev") + this.newline());
            writer.write(this.head("") + this.newline());
            writer.write(this.head("") + this.newline());
            writer.write(this.closeRow() + this.newline());
            double sum_avg_time = 0.0;
            double sum_best_result = 0.0;
            double sum_avg_result = 0.0;
            double sum_worst_result = 0.0;
            double sum_dev_result = 0.0;
            double sum_best_veh = 0.0;
            double sum_avg_veh = 0.0;
            double sum_worst_veh = 0.0;
            double sum_dev_veh = 0.0;
            Integer runs = null;
            Double sum_res_star = null;
            Double sum_veh_star = null;
            for (BenchmarkResult result : results) {
                if (runs == null) {
                    runs = result.runs;
                }
                writer.write(this.openRow() + this.newline());
                writer.write(this.date(result.instance.name) + this.newline());
                writer.write(this.date(Integer.valueOf(result.runs).toString()) + this.newline());
                Double avg_time = this.round(result.getTimesStats().getMean(), 2);
                writer.write(this.date(Double.valueOf(avg_time).toString()) + this.newline());
                Double best_result = this.round(result.getResultStats().getMin(), 2);
                writer.write(this.date(Double.valueOf(best_result).toString()) + this.newline());
                Double avg_result = this.round(result.getResultStats().getMean(), 2);
                writer.write(this.date(Double.valueOf(avg_result).toString()) + this.newline());
                Double worst_result = this.round(result.getResultStats().getMax(), 2);
                writer.write(this.date(Double.valueOf(worst_result).toString()) + this.newline());
                Double std_result = this.round(result.getResultStats().getStandardDeviation(), 2);
                writer.write(this.date(Double.valueOf(std_result).toString()) + this.newline());
                Double best_vehicle = this.round(result.getVehicleStats().getMin(), 2);
                writer.write(this.date(Double.valueOf(best_vehicle).toString()) + this.newline());
                Double avg_vehicle = this.round(result.getVehicleStats().getMean(), 2);
                writer.write(this.date(Double.valueOf(avg_vehicle).toString()) + this.newline());
                Double worst_vehicle = this.round(result.getVehicleStats().getMax(), 2);
                writer.write(this.date(Double.valueOf(worst_vehicle).toString()) + this.newline());
                Double std_vehicle = this.round(result.getVehicleStats().getStandardDeviation(), 2);
                writer.write(this.date(Double.valueOf(std_vehicle).toString()) + this.newline());
                writer.write(this.date("" + result.instance.bestKnownResult + this.newline()));
                writer.write(this.date("" + result.instance.bestKnownVehicles + this.newline()));
                writer.write(this.closeRow() + this.newline());
                sum_avg_time += avg_time.doubleValue();
                sum_best_result += best_result.doubleValue();
                sum_avg_result += avg_result.doubleValue();
                sum_worst_result += worst_result.doubleValue();
                sum_dev_result += std_result.doubleValue();
                sum_best_veh += best_vehicle.doubleValue();
                sum_avg_veh += avg_vehicle.doubleValue();
                sum_worst_veh += worst_vehicle.doubleValue();
                sum_dev_veh += std_vehicle.doubleValue();
                if (result.instance.bestKnownResult != null) {
                    sum_res_star = sum_res_star == null ? result.instance.bestKnownResult : Double.valueOf(sum_res_star + result.instance.bestKnownResult);
                }
                if (result.instance.bestKnownVehicles == null) continue;
                if (sum_veh_star == null) {
                    sum_veh_star = result.instance.bestKnownVehicles;
                    continue;
                }
                sum_veh_star = sum_veh_star + result.instance.bestKnownVehicles;
            }
            writer.write(this.openRow() + this.newline());
            writer.write(this.date("&Oslash;") + this.newline());
            writer.write(this.date("" + runs) + this.newline());
            Double average_time = this.round(sum_avg_time / (double)results.size(), 2);
            writer.write(this.date(Double.valueOf(average_time).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_best_result / (double)results.size(), 2)).toString()) + this.newline());
            Double average_result = this.round(sum_avg_result / (double)results.size(), 2);
            writer.write(this.date(Double.valueOf(average_result).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_worst_result / (double)results.size(), 2)).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_dev_result / (double)results.size(), 2)).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_best_veh / (double)results.size(), 2)).toString()) + this.newline());
            Double average_vehicles = this.round(sum_avg_veh / (double)results.size(), 2);
            writer.write(this.date(Double.valueOf(average_vehicles).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_worst_veh / (double)results.size(), 2)).toString()) + this.newline());
            writer.write(this.date(Double.valueOf(this.round(sum_dev_veh / (double)results.size(), 2)).toString()) + this.newline());
            Double delta_res = null;
            if (sum_res_star != null) {
                writer.write(this.date(Double.valueOf(this.round(sum_res_star / (double)results.size(), 2)).toString()) + this.newline());
                delta_res = (sum_avg_result / sum_res_star - 1.0) * 100.0;
            } else {
                writer.write(this.date("null") + this.newline());
            }
            Double delta_veh = null;
            if (sum_veh_star != null) {
                writer.write(this.date(Double.valueOf(this.round(sum_veh_star / (double)results.size(), 2)).toString()) + this.newline());
                delta_veh = (sum_avg_veh - sum_veh_star) / (double)results.size();
            } else {
                writer.write(this.date("null") + this.newline());
            }
            writer.write(this.closeRow() + this.newline());
            writer.write(this.closeTable() + this.newline());
            writer.write("avg. percentage deviation to best-known result: " + this.round(delta_res, 2) + this.newline() + this.newline());
            writer.write("avg. absolute deviation to best-known vehicles: " + this.round(delta_veh, 2) + this.newline());
            writer.write(this.openTable() + this.newline());
            writer.write(this.openRow() + this.newline());
            writer.write(this.date("") + this.newline());
            writer.write(this.date("") + this.newline());
            writer.write(this.date("") + this.newline());
            writer.write(this.date("") + this.newline());
            writer.write(this.date(Double.valueOf(average_time).toString(), "align=\"right\"") + this.newline());
            writer.write(this.date(Double.valueOf(average_result).toString(), "align=\"right\"") + this.newline());
            writer.write(this.date(Double.valueOf(average_vehicles).toString(), "align=\"right\"") + this.newline());
            if (delta_res != null) {
                writer.write(this.date(Double.valueOf(this.round(delta_res, 2)).toString(), "align=\"right\"") + this.newline());
            } else {
                writer.write(this.date("n.a.") + this.newline());
            }
            if (delta_veh != null) {
                writer.write(this.date(Double.valueOf(this.round(delta_veh, 2)).toString(), "align=\"right\"") + this.newline());
            } else {
                writer.write(this.date("n.a.") + this.newline());
            }
            writer.write(this.closeRow() + this.newline());
            writer.write(this.closeTable() + this.newline());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String head(String string, int i) {
        return "<th colspan=\"" + i + "\">" + string + "</th>";
    }

    private Double round(Double value, int i) {
        if (value == null) {
            return null;
        }
        long roundedVal = Math.round(value * Math.pow(10.0, i));
        return (double)roundedVal / Math.pow(10.0, i);
    }

    private String head(String head) {
        return "<th>" + head + "</th>";
    }

    private String closeTable() {
        return "</table>";
    }

    private String openTable() {
        return "<table>";
    }

    private String closeRow() {
        return "</tr>";
    }

    private String date(String date) {
        return "<td>" + date + "</td>";
    }

    private String date(String date, String metaData) {
        return "<td " + metaData + ">" + date + "</td>";
    }

    private String newline() {
        return "\n";
    }

    private String openRow() {
        return "<tr>";
    }
}

