/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.beans;

import com.mycomm.IProtocol.sql.annotation.UniversalDBColumType;

/**
 *
 * @author jw362j
 */
public enum JDataTypes {

    JByte("byte"),
    JShort("short"),
    JFloat("float"),
    JDouble("double"),
    JInt("int"),
    JLong("long"),
    JBoolean("boolean"),
    JString("String"),
    JDate("Date"),
    JChar1("char"),
    JChar8("char8"), JChar16("char16"),
    JChar32("char32"), JChar64("char64"), JChar128("char128"), JChar255("char255");
    private final String value;

    private JDataTypes(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static JDataTypes fromValue(String v) {
        if ("".equals(v) || v == null) {
            return null;
        }

        for (JDataTypes c : values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        return null;
    }

    public static JDataTypes fromUniversalDBColumType(UniversalDBColumType v) {
        if ("".equals(v) || v == null) {
            return null;
        }
        JDataTypes result = null;
        switch (v) {
            case DBColumByte:
                result = JByte;
                break;
            case DBColumShort:
                result = JShort;
                break;
            case DBColumFloat:
                result = JFloat;
                break;
            case DBColumDouble:
                result = JDouble;
                break;
            case DBColumInt:
                result = JInt;
                break;
            case DBColumLong:
                result = JLong;
                break;

            case DBColumBoolean:
                result = JBoolean;
                break;
            case DBColumString:
                result = JString;
                break;

            case DBColumVarChar8:
                result = JChar8;
                break;
            case DBColumVarChar16:
                result = JChar16;
                break;
            case DBColumVarChar24:
                result = JChar16;
                break;
            case DBColumVarChar32:
                result = JChar32;
                break;
            case DBColumVarChar64:
                result = JChar64;
                break;
            case DBColumVarChar128:
                result = JChar128;
                break;
            case DBColumVarChar255:
                result = JChar255;
                break;
            case DBColumDate:
                result = JDate;
                break;
            case DBColumChar:
                result = JChar1;
                break;

            default:
                result = null;
                break;
        }
        return result;
    }
}
