/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.beans;

/**
 *
 * @author jw362j
 */
public enum MySqlCharSet {
    
    TableCharSetDEFAULT(""),
    TableCharSetBIG5("big5"),
    TableCharSetDEC8("dec8"),
    TableCharSetCP850("cp850"),
    TableCharSetHP8("hp8"),
    TableCharSetKOI8R("koi8r"),
    TableCharSetLATIN1("latin1"),
    TableCharSetLATIN2("latin2"),
    TableCharSetSWE7("swe7"),
    TableCharSetASCII("ascii"),
    TableCharSetUJIS("ujis"),
    TableCharSetSJIS("sjis"),
    TableCharSetHEBREW("hebrew"),
    TableCharSetTIS620("geostd8"),
    TableCharSetEUCKR("euckr"),
    TableCharSetMACROMAN("macroman"),
    TableCharSetMACCE("macce"),
    TableCharSetKEYBCS2("keybcs2"),
    TableCharSetCP866("cp866"),
    TableCharSetUCS2("ucs2"),
    TableCharSetUTF8("utf8"),
    TableCharSetARMSCII8("armscii8"),
    TableCharSetLATIN5("latin5"),
    TableCharSetGBK("gbk"),
    TableCharSetCP1250("cp1250"),
    TableCharSetGREEK("greek"),
    TableCharSetGB2312("gb2312"),
    TableCharSetKOI8U("koi8u"),
    TableCharSetBINARY("binary"),
    TableCharSetUTF32("utf32"),
    TableCharSetCP1257("cp1257"),
    TableCharSetCP1256("cp1256"),
    TableCharSetUTF16LE("utf16le"),
    TableCharSetUTF16("utf16"),
    TableCharSetCP1251("cp1251"),
    TableCharSetUTF8MB4("utf8mb4"),
    TableCharSetLATIN7("latin7"),
    TableCharSetCP852("cp852"),
    TableCharSetGEOSTD8("geostd8"),
    TableCharSetEUCJPMS("eucjpms"),
    TableCharSetCP932("cp932");

    @Override
    public String toString() {
        return value;
    }

   
    private final String value;

    private MySqlCharSet(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static MySqlCharSet fromValue(String v) {
        if ("".equals(v) || v == null) {
            return TableCharSetDEFAULT;
        }

        for (MySqlCharSet c : values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
       return MySqlCharSet.TableCharSetUTF8;
    }
}
