/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.beans;

import com.mycomm.IProtocol.log.UniversalLogHolder;

/**
 *
 * @author jw362j
 */
public enum QueryCondition {
    /// where=age-greq-37,userName-eq-jiunian,address-lk-'%new york%'
    GreaterThan("gr"), LessThan("le"), Equals("eq"), Like("lk"), GreaterAndEqual("greq"), LessAndEqual("leeq");
    private final String value;

    private QueryCondition(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static QueryCondition fromValue(String v) {
        if ("".equals(v) || v == null) {
            return null;
        }

        for (QueryCondition c : values()) {
            UniversalLogHolder.d(QueryCondition.class.getSimpleName(), "QueryCondition values:" + c);
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw null;
    }

}
