/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.beans;

/**
 *
 * @author jw362j
 */
public class TableFieldStructure {

    private String attributeName;
    private String attributeDesc;
    private JDataTypes attributeDataType;
    private boolean isPrimaryKey;
    private boolean nullable;
    private boolean isUnique;
    private boolean isIndex;
    private boolean searchable;
    private String defaultValue;
    private String regexPattern;

    public TableFieldStructure() {
    }

    public TableFieldStructure(String attributeName, JDataTypes attributeDataType, boolean isPrimaryKey, boolean nullable) {
        this.attributeName = attributeName;
        this.attributeDataType = attributeDataType;
        this.isPrimaryKey = isPrimaryKey;
        this.nullable = nullable;
    }

    public TableFieldStructure(String attributeName, String attributeDesc, JDataTypes attributeDataType, boolean isPrimaryKey, boolean nullable, boolean isUnique, boolean isIndex, boolean searchable, String defaultValue, String regexPattern) {
        this.attributeName = attributeName;
        this.attributeDesc = attributeDesc;
        this.attributeDataType = attributeDataType;
        this.isPrimaryKey = isPrimaryKey;
        this.nullable = nullable;
        this.isUnique = isUnique;
        this.isIndex = isIndex;
        this.searchable = searchable;
        this.defaultValue = defaultValue;
        this.regexPattern = regexPattern;
    }

    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeDesc() {
        return attributeDesc;
    }

    public void setAttributeDesc(String attributeDesc) {
        this.attributeDesc = attributeDesc;
    }

    public JDataTypes getAttributeDataType() {
        return attributeDataType;
    }

    public void setAttributeDataType(JDataTypes attributeDataType) {
        this.attributeDataType = attributeDataType;
    }

    public boolean isIsPrimaryKey() {
        return isPrimaryKey;
    }

    public void setIsPrimaryKey(boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public boolean isNullable() {
        return nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isIsUnique() {
        return isUnique;
    }

    public void setIsUnique(boolean isUnique) {
        this.isUnique = isUnique;
    }

    public boolean isIsIndex() {
        return isIndex;
    }

    public void setIsIndex(boolean isIndex) {
        this.isIndex = isIndex;
    }

    public boolean isSearchable() {
        return searchable;
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getRegexPattern() {
        return regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    @Override
    public String toString() {
        return "TableFieldStructure{" + "attributeName=" + attributeName + ", attributeDesc=" + attributeDesc + ", attributeDataType=" + attributeDataType + ", isPrimaryKey=" + isPrimaryKey + ", nullable=" + nullable + ", isUnique=" + isUnique + ", isIndex=" + isIndex + ", searchable=" + searchable + ", defaultValue=" + defaultValue + ", regexPattern=" + regexPattern + '}';
    }

}
