/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.log;

/**
 *
 * @author jw362j
 */
public class UniversalLogHolder {

    private static UniversalLogSupporter logSupporter;

    public static void setLogSupporter(UniversalLogSupporter logSupporter) {
        UniversalLogHolder.logSupporter = logSupporter;
    }

    public static void w(String tag, String text) {
        if (logSupporter != null) {
            logSupporter.w(tag, text);
        }
    }

    public  static void e(String tag, String text) {
        if (logSupporter != null) {
            logSupporter.e(tag, text);
        }
    }

    public static  void d(String tag, String text) {
        if (logSupporter != null) {
            logSupporter.d(tag, text);
        }
    }

    public static  void i(String tag, String text) {
        if (logSupporter != null) {
            logSupporter.i(tag, text);
        }
    }

    public  static void v(String tag, String text) {
        if (logSupporter != null) {
            logSupporter.v(tag, text);
        }
    }
    public static boolean islogEnabled() {
        return logSupporter != null ;
    }

}
