/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycomm.IProtocol.sql.Clz2Sql;

import com.mycomm.IProtocol.log.UniversalLogHolder;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyOneToMany;
import com.mycomm.IProtocol.sql.annotation.MyOneToOne;
import com.mycomm.IProtocol.sql.annotation.MyTable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author jw362j
 */
public class AnnotationParser {

    private static final Map<Class, AnnotationStructureStrategy> annotationStructureStrategyCache = new HashMap<Class, AnnotationStructureStrategy>();

    public static String getTableName(Class classType) {
        MyTable myTable = getTlb(classType);
        if (myTable == null) {
            throw new RuntimeException("the MyTable Annotation is null!");
        }
        String theTableName = myTable.tableName();
        if ("".equals(theTableName) || theTableName == null) {
            theTableName = classType.getSimpleName();
        }

        if ("".equals(theTableName) || theTableName == null) {
            throw new RuntimeException("the table name in SQL is null!");
        }
        return theTableName;
    }

    public static MyTable getTlb(Class classType) {
        if (classType == null) {
            throw new RuntimeException("the classType is null!");
        }
        if (!classType.isAnnotationPresent(MyTable.class)) {
            throw new RuntimeException("the MyTable Annotation is not there!class is:" + classType);
        }
        MyTable myTable = (MyTable) classType.getAnnotation(MyTable.class);
        if (myTable == null) {
            throw new RuntimeException("the MyTable Annotation is null!");
        }
        return myTable;
    }

    public static String getTableIdColumName(Class classType) {
        if (classType == null) {
            throw new RuntimeException("the classType is null!");
        }
        Field[] fields = classType.getDeclaredFields();

        if (fields == null || fields.length <= 0) {
            throw new RuntimeException("the class fields are null!");
        }
        String theId = null;
        for (Field f : fields) {
            MyId ff = f.getAnnotation(MyId.class);
            if (ff == null) {
                continue;
            }
            theId = ff.IdColumName();
            if ("".equals(theId) || theId == null) {
                theId = f.getName();
            }
            break;
        }
        if ("".equals(theId) || theId == null) {
            throw new RuntimeException("the table id colum field is null!");
        }
        return theId;
    }

    public static Field getIdField(Class classType) {
        if (classType == null) {
            throw new RuntimeException("the classType is null!");
        }
        Field[] fields = classType.getDeclaredFields();

        if (fields == null || fields.length <= 0) {
            throw new RuntimeException("the class fields are null!");
        }
        for (Field f : fields) {
            MyId ff = f.getAnnotation(MyId.class);
            if (ff == null) {
                continue;
            }
            return f;
        }
        return null;
    }

    public static AnnotationStructureStrategy LoadAnnotationStructureStrategy(Class clz) {
        if (clz == null) {
            return null;
        }
        if (annotationStructureStrategyCache.containsKey(clz)) {
            return annotationStructureStrategyCache.get(clz);
        }
        String tableName = getTableName(clz);
        String IdColumName = getTableIdColumName(clz);

        List<String> fieldSimple = null;

        List<Field> fieldOneToOne = null;

        List<Field> fieldOneToMany = null;

        List<Field> simpleField = null;

        AnnotationStructureStrategy annotationStructureStrategy = new AnnotationStructureStrategy();
        annotationStructureStrategy.setTableName(tableName);
        annotationStructureStrategy.setIdColumName(IdColumName);//getIdField
        annotationStructureStrategy.setIdField(getIdField(clz));
        Field[] fields = clz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(MyColumn.class)) {
                MyColumn colum = field.getAnnotation(MyColumn.class);
                if (fieldSimple == null) {
                    fieldSimple = new ArrayList<String>();
                }
                if (simpleField == null) {
                    simpleField = new ArrayList<Field>();
                }
                String columnName = colum.ColumnName();
                if ("".equals(columnName) || columnName == null) {
                    columnName = field.getName();
                }
                fieldSimple.add(columnName);
                simpleField.add(field);
            }
            if (field.isAnnotationPresent(MyOneToOne.class)) {
                if (fieldOneToOne == null) {
                    fieldOneToOne = new ArrayList<Field>();
                }
                fieldOneToOne.add(field);
            }
            if (field.isAnnotationPresent(MyOneToMany.class)) {
                if (fieldOneToMany == null) {
                    fieldOneToMany = new ArrayList<Field>();
                }
                fieldOneToMany.add(field);
            }
        }
        Field[] fieldsOneToOne = null;
        Field[] fieldsOneToMany = null;
        String[] fieldsSimple = null;
        Field[] fieldsS = null;
        if (fieldOneToOne != null) {
            int flagOnetoOne = 0;
            fieldsOneToOne = new Field[fieldOneToOne.size()];
            for (Field f : fieldOneToOne) {
                fieldsOneToOne[flagOnetoOne++] = f;
            }
        }
        if (fieldOneToMany != null) {
            int flagOnetoMany = 0;
            fieldsOneToMany = new Field[fieldOneToMany.size()];
            for (Field f : fieldOneToMany) {
                fieldsOneToMany[flagOnetoMany++] = f;
            }
        }
        if (fieldSimple != null) {
            int flagSimple = 0;
            fieldsSimple = new String[fieldSimple.size()];
            for (String name : fieldSimple) {
                fieldsSimple[flagSimple++] = name;
            }
        }

        if (simpleField != null) {
            int flagSimple = 0;
            fieldsS = new Field[simpleField.size()];
            for (Field name : simpleField) {
                fieldsS[flagSimple++] = name;
            }
        }
        annotationStructureStrategy.setFieldOneToOne(fieldsOneToOne);
        annotationStructureStrategy.setFieldOneToMany(fieldsOneToMany);
        annotationStructureStrategy.setSimpleFieldsNames(fieldsSimple);
        annotationStructureStrategy.setSimpleFields(fieldsS);
        annotationStructureStrategyCache.put(clz, annotationStructureStrategy);
        return annotationStructureStrategy;
    }

    public static long getIdValue(Object object) {
        if (object == null) {
            throw new RuntimeException("the Object is null,no id value to get!");
        }
        Field[] fs = object.getClass().getDeclaredFields();
        if (fs == null || fs.length <= 0) {
            throw new RuntimeException("no DeclaredFields value to get!");
        }
        for (Field f : fs) {
            try {
                f.setAccessible(true);
                MyId ff = f.getAnnotation(MyId.class);
                if (ff == null) {
                    continue;
                }
                return f.getLong(object);
            } catch (IllegalArgumentException ex) {
                UniversalLogHolder.e(Class.class.getSimpleName(), "IllegalArgumentException:" + ex.getMessage());
            } catch (IllegalAccessException ex) {
                UniversalLogHolder.e(Class.class.getSimpleName(), "IllegalAccessException:" + ex.getMessage());
            }
        }
        return -1;
    }
}
