/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycomm.IProtocol.sql.Clz2Sql;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyOneToOne;
import com.mycomm.IProtocol.sql.annotation.UniversalDBColumType;
import java.lang.reflect.Field;

/**
 *
 * @author jw362j
 */
public class MySqlColumTypeDetector implements ColumTypeDetector {

    public String getColumType(JDataTypes jdt) {

        if (jdt == null) {
            throw new RuntimeException("invalide datatype null JavaDataTypes");
        }
        String myType = "";
        if (jdt.equals(JDataTypes.JByte)) {
            return " CHAR(1) ";
        }
        if (jdt.equals(JDataTypes.JShort)) {
            return " INTEGER ";
        }
        if (jdt.equals(JDataTypes.JFloat)) {
            return " FLOAT ";
        }
        if (jdt.equals(JDataTypes.JDouble)) {
            return " DOUBLE ";
        }
        if (jdt.equals(JDataTypes.JInt)) {
            return " INTEGER ";
        }
        if (jdt.equals(JDataTypes.JLong)) {
            return " BIGINT ";
        }
        if (jdt.equals(JDataTypes.JBoolean)) {
            return " BOOLEAN ";
        }
        if (jdt.equals(JDataTypes.JString)) {
            return " LONGTEXT ";
        }
        if (jdt.equals( JDataTypes.JChar1)) {
            return " CHAR(1) ";
        }
        if (jdt.equals(JDataTypes.JDate)) {
            return " DATETIME ";
        }

        return myType;
    }

    public String getColumType(UniversalDBColumType dbType) {        
        if (dbType == null) {
            throw new RuntimeException("invalide datatype null JavaDataTypes");
        }
        if (UniversalDBColumType.DBColumByte.equals(dbType)) {
            return " CHAR(1) ";
        }
        if (UniversalDBColumType.DBColumShort.equals(dbType)) {
            return " INTEGER ";
        }
        if (UniversalDBColumType.DBColumFloat.equals(dbType)) {
            return " FLOAT ";
        }
        if (UniversalDBColumType.DBColumDouble.equals(dbType)) {
            return " DOUBLE ";
        }
        if (UniversalDBColumType.DBColumInt.equals(dbType)) {
            return " INTEGER ";
        }
        if (UniversalDBColumType.DBColumLong.equals(dbType)) {
            return " BIGINT ";
        }
        if (UniversalDBColumType.DBColumBoolean.equals(dbType)) {
            return " BOOLEAN ";
        }
        if (UniversalDBColumType.DBColumDate.equals(dbType)) {
            return " DATETIME ";
        }

        if (UniversalDBColumType.DBColumChar.equals(dbType)) {
            return " CHAR(1) ";
        }

        if (UniversalDBColumType.DBColumString.equals(dbType)) {
            return " LONGTEXT ";
        }

        if (UniversalDBColumType.DBColumVarChar8.equals(dbType)) {
            return " VARCHAR(8) ";
        }

        if (UniversalDBColumType.DBColumVarChar16.equals(dbType)) {
            return " VARCHAR(16) ";
        }

        if (UniversalDBColumType.DBColumVarChar32.equals(dbType)) {
            return " VARCHAR(32) ";
        }
        if (UniversalDBColumType.DBColumVarChar64.equals(dbType)) {
            return " VARCHAR(64) ";
        }
        if (UniversalDBColumType.DBColumVarChar128.equals(dbType)) {
            return " VARCHAR(128) ";
        }
        if (UniversalDBColumType.DBColumVarChar255.equals(dbType)) {
            return " VARCHAR(256) ";
        }
        
        if (UniversalDBColumType.DBColumNull.equals(dbType)) {
            return null;
        }

        throw new RuntimeException("invalide datatype null JavaDataTypes");
    }

    public JDataTypes getJavaDataType(Field field) {
        
        if (field == null) {
            throw new IllegalArgumentException("the Field is null!");
        }
        if (field.getType() == null) {
            throw new IllegalArgumentException("field.getType() == null");
        }
        boolean canGo = false;
        if(field.isAnnotationPresent(MyColumn.class) || field.isAnnotationPresent(MyId.class) || field.isAnnotationPresent(MyOneToOne.class) ){
            canGo = true;
        }
        if(!canGo){
           return null;
        }
        boolean isOneToOne = field.isAnnotationPresent(MyOneToOne.class);
        String JType = field.getType().toString();
        JType = JType.toLowerCase();
        if (JType.contains("byte")) {
            return JDataTypes.JByte;
        }

        if (JType.contains("short")) {
            return JDataTypes.JShort;
        }
        if (JType.contains("float")) {
            return JDataTypes.JFloat;
        }
        if (JType.contains("double")) {
            return JDataTypes.JDouble;
        }
        if (JType.contains("int")) {
            return JDataTypes.JInt;
        }
        if (JType.contains("long")) {
            return JDataTypes.JLong;
        }
        if (JType.contains("boolean")) {
            return JDataTypes.JBoolean;
        }
        if (JType.contains("string")) {
            return JDataTypes.JString;
        }
        if (JType.contains("char")) {
            return JDataTypes.JChar1;
        }
        if (JType.contains("date")) {
            return JDataTypes.JDate;
        }else{
            return JDataTypes.JString;
        }
    }

}
