/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.sql.Clz2Sql;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.beans.MySqlCharSet;
import com.mycomm.IProtocol.log.UniversalLogHolder;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author jw362j
 */
public class MySqlDataBaseBuilder implements SQLBuilder {

    private static final String quotation_mark = "`";
    private final ColumTypeDetector typeDetector = new MySqlColumTypeDetector();
    private static final Map<Class, String> sql_create_Table = new HashMap<Class, String>();
    private static final Map<Class, String> sql_insert_Table = new HashMap<Class, String>();
    private static final Map<Class, String> sql_update_Table = new HashMap<Class, String>();

    public String doCreateTable(Class beanClz) {
        if (beanClz == null) {
            throw new IllegalArgumentException("beanClz is null in MySqlDataBaseBuilder.doCreateTable....");
        }
        if (sql_create_Table.containsKey(beanClz)) {
            return sql_create_Table.get(beanClz);
        }
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);//getTableName();
        MyTable myTable = (MyTable) beanClz.getAnnotation(MyTable.class);
        Field[] fields = beanClz.getDeclaredFields();

        String sqlCreateTable = "CREATE TABLE IF NOT EXISTS " + quotation_mark + structureStrategy.getTableName() + quotation_mark + " ( " + quotation_mark + structureStrategy.getIdColumName() + quotation_mark + " bigint  NOT NULL AUTO_INCREMENT,";
        String colName;
        String colType;
        MySqlCharSet universalCharSet = myTable.tableCharset();
        String tableCharset = (universalCharSet == null) ? "" : universalCharSet.getValue();
        String tableEngine = myTable.tableEngine().getValue();

        String uniqueColum = null;
        for (Field field : fields) {
            if (field.isAnnotationPresent(MyId.class)) {
                continue;
            }
            field.setAccessible(true);
            if (field.isAnnotationPresent(MyColumn.class)) {
                MyColumn myColumn = (MyColumn) field.getAnnotation(MyColumn.class);
                //initial for columName
                colName = myColumn.ColumnName();
                if ("".equals(colName) || colName == null) {
                    colName = field.getName();
                }
                colName = quotation_mark + colName + quotation_mark + " ";
                sqlCreateTable += colName;

                //initial for columType
                colType = typeDetector.getColumType(myColumn.ColumnType());
                //UniversalLogHolder.d(getClass().getSimpleName(), "colType is---:" + colType);
                if ("".equals(colType) || colType == null) {
                    //use the fiels`s data type
                    JDataTypes jDataType = typeDetector.getJavaDataType(field);

                    colType = typeDetector.getColumType(jDataType);
                }
                //UniversalLogHolder.d(getClass().getSimpleName(), "colType is:" + colType);
                sqlCreateTable = sqlCreateTable + " " + colType + " ";
                if (myColumn.isColumnNullable()) {
                    sqlCreateTable += ",";
                }

                //initial for colNullable
                if (!myColumn.isColumnNullable()) {
                    if (field.getType().toString().contains("String") || field.getType().toString().contains("char")) {
                        sqlCreateTable = sqlCreateTable + " NOT NULL DEFAULT " + quotation_mark + myColumn.ColumnDefaultValue() + quotation_mark + ",";
                    } else {
                        sqlCreateTable = sqlCreateTable + " NOT NULL DEFAULT " + myColumn.ColumnDefaultValue() + ",";
                    }
                }
                if (myColumn.isColumnUnique()) {
                    uniqueColum = colName;
                }
            }

        }
        String theEngine = ("".equals(tableEngine) || tableEngine == null) ? " " : (" ENGINE=" + tableEngine + " ");
        String charSet = ("".equals(tableCharset) || tableCharset == null) ? " " : (" DEFAULT CHARSET=" + tableCharset);
        sqlCreateTable = sqlCreateTable + " PRIMARY KEY ( " + quotation_mark + structureStrategy.getIdColumName() + quotation_mark + ") " + (uniqueColum == null ? "" : " , UNIQUE KEY " + uniqueColum + " (" + uniqueColum + ")") + ")" + theEngine + charSet;
        sql_create_Table.put(beanClz, sqlCreateTable);
        return sqlCreateTable;
    }

    public String doInsertInToTable(Class beanClz) {
        if (sql_insert_Table.containsKey(beanClz)) {
            return sql_insert_Table.get(beanClz);
        }
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);
        final StringBuffer sql_saveList = new StringBuffer("INSERT INTO " + structureStrategy.getTableName() + "(");
        Field[] fields = beanClz.getDeclaredFields();
        int fieldCounter = 0;
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(MyId.class)) {
                continue;
            }
            if (field.isAnnotationPresent(MyColumn.class)) {
                MyColumn myColumn = (MyColumn) field.getAnnotation(MyColumn.class);
                String columName = myColumn.ColumnName();

                if ("".equals(columName) || columName == null) {
                    columName = field.getName();
                }
                sql_saveList.append(quotation_mark).append(columName).append(quotation_mark).append(",");
                fieldCounter++;
            }
        }
        sql_saveList.deleteCharAt(sql_saveList.length() - 1);
        sql_saveList.append(")  VALUES(");
        for (int i = 0; i < fieldCounter; i++) {
            if (i != fieldCounter - 1) {
                sql_saveList.append(" ? ,");
            } else {
                sql_saveList.append(" ? )");
            }
        }
        UniversalLogHolder.d(getClass().getSimpleName(), "the doInsertInToTable sql===:" + sql_saveList);
        if (sql_saveList == null) {
            throw new RuntimeException("sql_save insert is null");
        }
        sql_insert_Table.put(beanClz, sql_saveList.toString());
        return sql_saveList.toString();
    }

    public String doUpdateTable(Class beanClz, List<String> projection) {
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);
        if (projection == null || projection.isEmpty()) {
            if (sql_update_Table.containsKey(beanClz)) {
                return sql_update_Table.get(beanClz);
            }
            //full update sql
            StringBuilder sql_update = new StringBuilder("UPDATE " + structureStrategy.getTableName() + " SET ");
            Field[] fields = beanClz.getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);

                if (field.isAnnotationPresent(MyColumn.class)) {
                    MyColumn myColumn = (MyColumn) field.getAnnotation(MyColumn.class);
                    String columName = myColumn.ColumnName();
                    if ("".equals(columName) || columName == null) {
                        columName = field.getName();
                    }
                    sql_update.append(quotation_mark).append(columName).append(quotation_mark + " = ? ,");
                }
            }
            sql_update.deleteCharAt(sql_update.length() - 1);
            sql_update.append(" WHERE ").append(structureStrategy.getIdColumName()).append("=?");
            UniversalLogHolder.d(getClass().getSimpleName(), "sqlUpdate:" + sql_update);
            sql_update_Table.put(beanClz, sql_update.toString());
            return sql_update.toString();
        }

        StringBuilder sql_halfUpdate = new StringBuilder("UPDATE " + structureStrategy.getTableName() + " SET ");
        for (String colum : projection) {
            sql_halfUpdate.append(quotation_mark).append(colum).append(quotation_mark + " = ? ,");
        }
        sql_halfUpdate.deleteCharAt(sql_halfUpdate.length() - 1);
        sql_halfUpdate.append(" WHERE ").append(structureStrategy.getIdColumName()).append("=?");
        UniversalLogHolder.d(getClass().getSimpleName(), "sqlHalfUpdate:" + sql_halfUpdate.toString());
        return sql_halfUpdate.toString();
    }

}
