/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.sql;

/**
 *
 * @author jw362j
 */
public enum MySqlEngine {

    EngineFEDERATED("FEDERATED"),
    EngineMRGMYISAM("MRG_MYISAM"),
    EngineMyISAM("MyISAM"),
    EngineBLACKHOLE("BLACKHOLE"),
    EngineCSV("CSV"),
    EngineMEMORY("MEMORY"),
    EngineARCHIVE("ARCHIVE"),
    EnginePERFORMANCESCHEMA("PERFORMANCE_SCHEMA"),
    EngineInnoDB("InnoDB"),
    EngineDEFAULT("");

    @Override
    public String toString() {
        return value;
    }

    @SuppressWarnings("FieldMayBeFinal")
    private String value;

    private MySqlEngine(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static MySqlEngine fromValue(String v) {
        if ("".equals(v) || v == null) {
            return MySqlEngine.EngineDEFAULT;
        }

        for (MySqlEngine c : values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        return MySqlEngine.EngineDEFAULT;
    }
}
