/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.mycomm.IProtocol.sql.annotation;

/**
 *
 * @author jw362j
 */
public enum UniversalDBColumType {
    DBColumNull(""),
    DBColumByte("byte"),
    DBColumShort("short"),
    DBColumFloat("float"),
    DBColumDouble("double"),
    DBColumInt("int"),
    DBColumLong("long"),
    DBColumBoolean("boolean"),
    DBColumString("String"),
    DBColumVarChar8("VarChar8"),
    DBColumVarChar16("VarChar16"),
    DBColumVarChar24("VarChar24"),
    DBColumVarChar32("VarChar32"),
    DBColumVarChar64("VarChar64"),
    DBColumVarChar128("VarChar128"),
    DBColumVarChar255("VarChar255"),
    DBColumDate("Date"),
    DBColumChar("char");

    @SuppressWarnings("FieldMayBeFinal")
    private String value;

    private UniversalDBColumType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static UniversalDBColumType fromValue(String v) {
        if ("".equals(v) || v == null) {
            return UniversalDBColumType.DBColumNull;
        }

        for (UniversalDBColumType c : values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        
        return UniversalDBColumType.DBColumNull;
    }
}
