/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.utils;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.beans.TableFieldStructure;
import com.mycomm.IProtocol.sql.Clz2Sql.AnnotationParser;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author jw362j
 */
public class Clazz2TableFields {

    private static final Map<Class, RemoteTable> tabls = new HashMap<Class, RemoteTable>();

    public static RemoteTable loadTableFields(Class clz) {
        if (clz == null) {
            return null;
        }
        if (tabls.containsKey(clz)) {
            return tabls.get(clz);
        }
        MyTable myTable = AnnotationParser.getTlb(clz);
        String tname = AnnotationParser.LoadAnnotationStructureStrategy(clz).getTableName();
        RemoteTable remoteTable = new RemoteTable(myTable.tableEngine(), myTable.tableCharset(), tname);
        Field[] fields = clz.getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if ((!field.isAnnotationPresent(MyColumn.class)) && (!field.isAnnotationPresent(MyId.class))) {
                continue;
            }
            String attName = null;
            if (field.isAnnotationPresent(MyId.class)) {
                MyId id_ = field.getAnnotation(MyId.class);
                attName = ("".equals(id_.IdColumName()) || id_.IdColumName() == null) ? field.getName() : id_.IdColumName();
                remoteTable.addField(new TableFieldStructure(("".equals(attName) || attName == null) ? field.getName() : attName, "", JDataTypes.JLong, true, false, true, true, true, "0", null));
                continue;
            }
            MyColumn colum = field.getAnnotation(MyColumn.class);
            attName = colum.ColumnName();
            remoteTable.addField(new TableFieldStructure(("".equals(attName) || attName == null) ? field.getName() : attName, colum.ColumnDescription(), JDataTypes.fromUniversalDBColumType(colum.ColumnType()), false, colum.isColumnNullable(), colum.isColumnUnique(), colum.isIndex(), colum.searchable(), colum.ColumnDefaultValue(), colum.regexPattern()));
        }
        tabls.put(clz, remoteTable);
        return remoteTable;
    }
}
