/*
 * Copyright 2018 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.utils;

import com.mycomm.IProtocol.beans.UsrToken;
import com.mycomm.IProtocol.cache.LruMapCache;
import java.util.Map;

/**
 *
 * @author jw362j
 */
public class DefaultUsrTokenOperator implements UsrTokenOperator {

    private static Map<String, UsrToken> tokens = new LruMapCache<String, UsrToken>(10000);
    private static Map<String, String> uid2Token = new LruMapCache<String, String>(10000);

    public void saveToken(UsrToken usrToken) {
        if (usrToken == null || usrToken.getTokenValue() == null || usrToken.getBelongToUid() == null) {
            return;
        }
        tokens.put(usrToken.getTokenValue(), usrToken);
        uid2Token.put(usrToken.getBelongToUid(), usrToken.getTokenValue());
    }

    public UsrToken loadUsrTokenByToken(String token) {
        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken;
        }
        tokens.remove(token);
        return null;
    }

    public UsrToken loadUsrTokenByUid(String uid) {
        if (uid == null || "".equals(uid)) {
            return null;
        }
        String token = uid2Token.get(uid);
        if (token == null || "".equals(token)) {
            return null;
        }

        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken;
        }
        tokens.remove(token);
        uid2Token.remove(uid);
        return null;
    }

    public String loadUidByToken(String token) {
        if (token == null || "".equals(token)) {
            return null;
        }
        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken.getBelongToUid();
        }
        tokens.remove(token);
        return null;
    }

}
