/*
 * Copyright 2019 jw362j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.mycomm.IProtocol.utils;

import com.mycomm.IProtocol.beans.MySqlCharSet;
import com.mycomm.IProtocol.beans.TableFieldStructure;
import com.mycomm.IProtocol.sql.MySqlEngine;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author jw362j
 */
public class RemoteTable {
    private MySqlEngine engine;
    private MySqlCharSet charSet;
    private String tableName;
    private final List<TableFieldStructure> tableFieldStructures = new ArrayList<TableFieldStructure>();

    public RemoteTable() {
    }

    public RemoteTable(MySqlEngine engine, MySqlCharSet charSet, String tableName) {
        this.engine = engine;
        this.charSet = charSet;
        this.tableName = tableName;
    }

    public MySqlEngine getEngine() {
        return engine;
    }

    public void setEngine(MySqlEngine engine) {
        this.engine = engine;
    }

    public MySqlCharSet getCharSet() {
        return charSet;
    }

    public void setCharSet(MySqlCharSet charSet) {
        this.charSet = charSet;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<TableFieldStructure> getTableFieldStructures() {
        return tableFieldStructures;
    }
    public void addField(TableFieldStructure structure){
        if(structure == null){
            return;
        }
        tableFieldStructures.add(structure);
    }

    @Override
    public String toString() {
        return "RemoteTable{" + "engine=" + engine + ", charSet=" + charSet + ", tableName=" + tableName + ", tableFieldStructures=" + tableFieldStructures + '}';
    }
    
}
