/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.IProtocol.sql.Clz2Sql;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.beans.MySqlCharSet;
import com.mycomm.IProtocol.log.UniversalLogHolder;
import com.mycomm.IProtocol.sql.Clz2Sql.AnnotationParser;
import com.mycomm.IProtocol.sql.Clz2Sql.AnnotationStructureStrategy;
import com.mycomm.IProtocol.sql.Clz2Sql.ColumTypeDetector;
import com.mycomm.IProtocol.sql.Clz2Sql.MySqlColumTypeDetector;
import com.mycomm.IProtocol.sql.Clz2Sql.SQLBuilder;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDataBaseBuilder
implements SQLBuilder {
    private static final String quotation_mark = "`";
    private final ColumTypeDetector typeDetector = new MySqlColumTypeDetector();
    private static final Map<Class, String> sql_create_Table = new HashMap<Class, String>();
    private static final Map<Class, String> sql_insert_Table = new HashMap<Class, String>();
    private static final Map<Class, String> sql_update_Table = new HashMap<Class, String>();

    @Override
    public String doCreateTable(Class beanClz) {
        if (beanClz == null) {
            throw new IllegalArgumentException("beanClz is null in MySqlDataBaseBuilder.doCreateTable....");
        }
        if (sql_create_Table.containsKey(beanClz)) {
            return sql_create_Table.get(beanClz);
        }
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);
        MyTable myTable = beanClz.getAnnotation(MyTable.class);
        Field[] fields = beanClz.getDeclaredFields();
        String sqlCreateTable = "CREATE TABLE IF NOT EXISTS `" + structureStrategy.getTableName() + quotation_mark + " ( " + quotation_mark + structureStrategy.getIdColumName() + quotation_mark + " bigint  NOT NULL AUTO_INCREMENT,";
        MySqlCharSet universalCharSet = myTable.tableCharset();
        String tableCharset = universalCharSet == null ? "" : universalCharSet.getValue();
        String tableEngine = myTable.tableEngine().getValue();
        String uniqueColum = null;
        for (Field field : fields) {
            if (field.isAnnotationPresent(MyId.class)) continue;
            field.setAccessible(true);
            if (!field.isAnnotationPresent(MyColumn.class)) continue;
            MyColumn myColumn = field.getAnnotation(MyColumn.class);
            String colName = myColumn.ColumnName();
            if ("".equals(colName) || colName == null) {
                colName = field.getName();
            }
            colName = quotation_mark + colName + quotation_mark + " ";
            sqlCreateTable = sqlCreateTable + colName;
            String colType = this.typeDetector.getColumType(myColumn.ColumnType());
            if ("".equals(colType) || colType == null) {
                JDataTypes jDataType = this.typeDetector.getJavaDataType(field);
                colType = this.typeDetector.getColumType(jDataType);
            }
            sqlCreateTable = sqlCreateTable + " " + colType + " ";
            if (myColumn.isColumnNullable()) {
                sqlCreateTable = sqlCreateTable + ",";
            }
            if (!myColumn.isColumnNullable()) {
                sqlCreateTable = field.getType().toString().contains("String") || field.getType().toString().contains("char") ? sqlCreateTable + " NOT NULL DEFAULT " + quotation_mark + myColumn.ColumnDefaultValue() + quotation_mark + "," : sqlCreateTable + " NOT NULL DEFAULT " + myColumn.ColumnDefaultValue() + ",";
            }
            if (!myColumn.isColumnUnique()) continue;
            uniqueColum = colName;
        }
        String theEngine = "".equals(tableEngine) || tableEngine == null ? " " : " ENGINE=" + tableEngine + " ";
        String charSet = "".equals(tableCharset) || tableCharset == null ? " " : " DEFAULT CHARSET=" + tableCharset;
        sqlCreateTable = sqlCreateTable + " PRIMARY KEY ( " + quotation_mark + structureStrategy.getIdColumName() + quotation_mark + ") " + (uniqueColum == null ? "" : " , UNIQUE KEY " + uniqueColum + " (" + uniqueColum + ")") + ")" + theEngine + charSet;
        sql_create_Table.put(beanClz, sqlCreateTable);
        return sqlCreateTable;
    }

    @Override
    public String doInsertInToTable(Class beanClz) {
        if (sql_insert_Table.containsKey(beanClz)) {
            return sql_insert_Table.get(beanClz);
        }
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);
        StringBuffer sql_saveList = new StringBuffer("INSERT INTO " + structureStrategy.getTableName() + "(");
        Field[] fields = beanClz.getDeclaredFields();
        int fieldCounter = 0;
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(MyId.class) || !field.isAnnotationPresent(MyColumn.class)) continue;
            MyColumn myColumn = field.getAnnotation(MyColumn.class);
            String columName = myColumn.ColumnName();
            if ("".equals(columName) || columName == null) {
                columName = field.getName();
            }
            sql_saveList.append(quotation_mark).append(columName).append(quotation_mark).append(",");
            ++fieldCounter;
        }
        sql_saveList.deleteCharAt(sql_saveList.length() - 1);
        sql_saveList.append(")  VALUES(");
        for (int i = 0; i < fieldCounter; ++i) {
            if (i != fieldCounter - 1) {
                sql_saveList.append(" ? ,");
                continue;
            }
            sql_saveList.append(" ? )");
        }
        UniversalLogHolder.d(this.getClass().getSimpleName(), "the doInsertInToTable sql===:" + sql_saveList);
        if (sql_saveList == null) {
            throw new RuntimeException("sql_save insert is null");
        }
        sql_insert_Table.put(beanClz, sql_saveList.toString());
        return sql_saveList.toString();
    }

    @Override
    public String doUpdateTable(Class beanClz, List<String> projection) {
        AnnotationStructureStrategy structureStrategy = AnnotationParser.LoadAnnotationStructureStrategy(beanClz);
        if (projection == null || projection.isEmpty()) {
            Field[] fields;
            if (sql_update_Table.containsKey(beanClz)) {
                return sql_update_Table.get(beanClz);
            }
            StringBuilder sql_update = new StringBuilder("UPDATE " + structureStrategy.getTableName() + " SET ");
            for (Field field : fields = beanClz.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(MyColumn.class)) continue;
                MyColumn myColumn = field.getAnnotation(MyColumn.class);
                String columName = myColumn.ColumnName();
                if ("".equals(columName) || columName == null) {
                    columName = field.getName();
                }
                sql_update.append(quotation_mark).append(columName).append("` = ? ,");
            }
            sql_update.deleteCharAt(sql_update.length() - 1);
            sql_update.append(" WHERE ").append(structureStrategy.getIdColumName()).append("=?");
            UniversalLogHolder.d(this.getClass().getSimpleName(), "sqlUpdate:" + sql_update);
            sql_update_Table.put(beanClz, sql_update.toString());
            return sql_update.toString();
        }
        StringBuilder sql_halfUpdate = new StringBuilder("UPDATE " + structureStrategy.getTableName() + " SET ");
        for (String colum : projection) {
            sql_halfUpdate.append(quotation_mark).append(colum).append("` = ? ,");
        }
        sql_halfUpdate.deleteCharAt(sql_halfUpdate.length() - 1);
        sql_halfUpdate.append(" WHERE ").append(structureStrategy.getIdColumName()).append("=?");
        UniversalLogHolder.d(this.getClass().getSimpleName(), "sqlHalfUpdate:" + sql_halfUpdate.toString());
        return sql_halfUpdate.toString();
    }
}

