/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.IProtocol.utils;

import com.mycomm.IProtocol.beans.JDataTypes;
import com.mycomm.IProtocol.beans.TableFieldStructure;
import com.mycomm.IProtocol.sql.Clz2Sql.AnnotationParser;
import com.mycomm.IProtocol.sql.annotation.MyColumn;
import com.mycomm.IProtocol.sql.annotation.MyId;
import com.mycomm.IProtocol.sql.annotation.MyTable;
import com.mycomm.IProtocol.utils.RemoteTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class Clazz2TableFields {
    private static final Map<Class, RemoteTable> tabls = new HashMap<Class, RemoteTable>();

    public static RemoteTable loadTableFields(Class clz) {
        Field[] fields;
        if (clz == null) {
            return null;
        }
        if (tabls.containsKey(clz)) {
            return tabls.get(clz);
        }
        MyTable myTable = AnnotationParser.getTlb(clz);
        String tname = AnnotationParser.LoadAnnotationStructureStrategy(clz).getTableName();
        RemoteTable remoteTable = new RemoteTable(myTable.tableEngine(), myTable.tableCharset(), tname);
        for (Field field : fields = clz.getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(MyColumn.class) && !field.isAnnotationPresent(MyId.class)) continue;
            String attName = null;
            if (field.isAnnotationPresent(MyId.class)) {
                MyId id_ = field.getAnnotation(MyId.class);
                attName = "".equals(id_.IdColumName()) || id_.IdColumName() == null ? field.getName() : id_.IdColumName();
                remoteTable.addField(new TableFieldStructure("".equals(attName) || attName == null ? field.getName() : attName, "", JDataTypes.JLong, true, false, true, true, true, "0", null));
                continue;
            }
            MyColumn colum = field.getAnnotation(MyColumn.class);
            attName = colum.ColumnName();
            remoteTable.addField(new TableFieldStructure("".equals(attName) || attName == null ? field.getName() : attName, colum.ColumnDescription(), JDataTypes.fromUniversalDBColumType(colum.ColumnType()), false, colum.isColumnNullable(), colum.isColumnUnique(), colum.isIndex(), colum.searchable(), colum.ColumnDefaultValue(), colum.regexPattern()));
        }
        tabls.put(clz, remoteTable);
        return remoteTable;
    }
}

