/*
 * Decompiled with CFR 0.152.
 */
package com.mycomm.IProtocol.utils;

import com.mycomm.IProtocol.beans.UsrToken;
import com.mycomm.IProtocol.cache.LruMapCache;
import com.mycomm.IProtocol.utils.UsrTokenOperator;
import java.util.Map;

public class DefaultUsrTokenOperator
implements UsrTokenOperator {
    private static Map<String, UsrToken> tokens = new LruMapCache<String, UsrToken>(10000);
    private static Map<String, String> uid2Token = new LruMapCache<String, String>(10000);

    public void saveToken(UsrToken usrToken) {
        if (usrToken == null || usrToken.getTokenValue() == null || usrToken.getBelongToUid() == null) {
            return;
        }
        tokens.put(usrToken.getTokenValue(), usrToken);
        uid2Token.put(usrToken.getBelongToUid(), usrToken.getTokenValue());
    }

    public UsrToken loadUsrTokenByToken(String token) {
        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken;
        }
        tokens.remove(token);
        return null;
    }

    public UsrToken loadUsrTokenByUid(String uid) {
        if (uid == null || "".equals(uid)) {
            return null;
        }
        String token = uid2Token.get(uid);
        if (token == null || "".equals(token)) {
            return null;
        }
        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken;
        }
        tokens.remove(token);
        uid2Token.remove(uid);
        return null;
    }

    public String loadUidByToken(String token) {
        if (token == null || "".equals(token)) {
            return null;
        }
        UsrToken usrToken = tokens.get(token);
        if (usrToken == null) {
            return null;
        }
        if (usrToken.getExpireTimeStamp() > System.currentTimeMillis()) {
            return usrToken.getBelongToUid();
        }
        tokens.remove(token);
        return null;
    }
}

