/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.partition.operation.PartitionReplicaSyncResponse;
import com.hazelcast.internal.partition.operation.PartitionReplicaSyncRetryResponse;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class PartitionReplicaSyncRequest
extends AbstractPartitionOperation
implements PartitionAwareOperation,
MigrationCycleOperation,
Versioned {
    private Collection<ServiceNamespace> allNamespaces;

    public PartitionReplicaSyncRequest() {
        this.allNamespaces = Collections.emptySet();
    }

    public PartitionReplicaSyncRequest(int partitionId, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.allNamespaces = namespaces;
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public void beforeRun() throws Exception {
        int syncReplicaIndex = this.getReplicaIndex();
        if (syncReplicaIndex < 1 || syncReplicaIndex > 6) {
            throw new IllegalArgumentException("Replica index " + syncReplicaIndex + " should be in the range [1-" + 6 + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (!partitionService.isMigrationAllowed()) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Migration is paused! Cannot run replica sync -> " + this.toString());
            }
            this.sendRetryResponse();
            return;
        }
        if (!this.preCheckReplicaSync(nodeEngine, partitionId, replicaIndex)) {
            return;
        }
        try {
            PartitionReplicationEvent event = new PartitionReplicationEvent(partitionId, replicaIndex);
            if (this.allNamespaces.remove(NonFragmentedServiceNamespace.INSTANCE)) {
                Collection<Operation> operations = this.createNonFragmentedReplicationOperations(event);
                this.sendOperations(operations, NonFragmentedServiceNamespace.INSTANCE);
            }
            for (ServiceNamespace namespace : this.allNamespaces) {
                Collection<Operation> operations = this.createFragmentReplicationOperations(event, namespace);
                this.sendOperations(operations, namespace);
            }
        }
        finally {
            partitionService.getReplicaManager().releaseReplicaSyncPermit();
        }
    }

    private void sendOperations(Collection<Operation> operations, ServiceNamespace ns) throws Exception {
        if (operations.isEmpty()) {
            this.logNoReplicaDataFound(this.getPartitionId(), ns, this.getReplicaIndex());
            this.sendResponse(null, ns);
        } else {
            this.sendResponse(operations, ns);
        }
    }

    private boolean preCheckReplicaSync(NodeEngineImpl nodeEngine, int partitionId, int replicaIndex) throws IOException {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(partitionId);
        Address owner = partition.getOwnerOrNull();
        ILogger logger = this.getLogger();
        if (!nodeEngine.getThisAddress().equals(owner)) {
            if (logger.isFinestEnabled()) {
                logger.finest("Wrong target! " + this.toString() + " cannot be processed! Target should be: " + owner);
            }
            this.sendRetryResponse();
            return false;
        }
        if (!partitionService.getReplicaManager().tryToAcquireReplicaSyncPermit()) {
            if (logger.isFinestEnabled()) {
                logger.finest("Max parallel replication process limit exceeded! Could not run replica sync -> " + this.toString());
            }
            this.sendRetryResponse();
            return false;
        }
        return true;
    }

    private void sendRetryResponse() {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionReplicaSyncRetryResponse response = new PartitionReplicaSyncRetryResponse(this.allNamespaces);
        response.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Address target = this.getCallerAddress();
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(response, target);
    }

    private void sendResponse(Collection<Operation> operations, ServiceNamespace ns) throws IOException {
        NodeEngine nodeEngine = this.getNodeEngine();
        PartitionReplicaSyncResponse syncResponse = this.createResponse(operations, ns);
        Address target = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Sending sync response to -> " + target + " for partitionId=" + this.getPartitionId() + ", replicaIndex=" + this.getReplicaIndex() + ", namespaces=" + ns);
        }
        syncResponse.setTarget(target);
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(syncResponse, target);
    }

    private PartitionReplicaSyncResponse createResponse(Collection<Operation> operations, ServiceNamespace ns) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        InternalPartitionService partitionService = (InternalPartitionService)this.getService();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        long[] versions = versionManager.getPartitionReplicaVersions(partitionId, ns);
        PartitionReplicaSyncResponse syncResponse = new PartitionReplicaSyncResponse(operations, ns, versions);
        syncResponse.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        return syncResponse;
    }

    private void logNoReplicaDataFound(int partitionId, ServiceNamespace namespace, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("No replica data is found for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", namespace= " + namespace);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.allNamespaces.size());
        for (ServiceNamespace namespace : this.allNamespaces) {
            out.writeObject(namespace);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int len = in.readInt();
        this.allNamespaces = new ArrayList<ServiceNamespace>(len);
        for (int i = 0; i < len; ++i) {
            ServiceNamespace ns = (ServiceNamespace)in.readObject();
            this.allNamespaces.add(ns);
        }
    }

    @Override
    public int getId() {
        return 11;
    }
}

