/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore.client;

import com.hazelcast.concurrent.semaphore.client.SemaphoreRequest;
import com.hazelcast.concurrent.semaphore.operations.AcquireOperation;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class AcquireRequest
extends SemaphoreRequest {
    private long timeout;

    public AcquireRequest() {
    }

    public AcquireRequest(String name, int permitCount, long timeout) {
        super(name, permitCount);
        this.timeout = timeout;
    }

    @Override
    protected Operation prepareOperation() {
        return new AcquireOperation(this.name, this.permitCount, this.timeout);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeLong("t", this.timeout);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.timeout = reader.readLong("t");
    }

    @Override
    public Permission getRequiredPermission() {
        return new SemaphorePermission(this.name, "acquire");
    }
}

