/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.DefaultNodeContext;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@PrivateApi
public final class HazelcastInstanceFactory {
    private static final ConcurrentMap<String, InstanceFuture> instanceMap = new ConcurrentHashMap<String, InstanceFuture>(5);
    private static final AtomicInteger factoryIdGen = new AtomicInteger();

    public static Set<HazelcastInstance> getAllHazelcastInstances() {
        HashSet<HazelcastInstance> result = new HashSet<HazelcastInstance>();
        for (InstanceFuture f : instanceMap.values()) {
            result.add(f.get());
        }
        return result;
    }

    public static HazelcastInstance getHazelcastInstance(String instanceName) {
        InstanceFuture instanceFuture = (InstanceFuture)instanceMap.get(instanceName);
        if (instanceFuture == null) {
            return null;
        }
        try {
            return instanceFuture.get();
        }
        catch (IllegalStateException t) {
            return null;
        }
    }

    public static HazelcastInstance getOrCreateHazelcastInstance(Config config) {
        if (config == null) {
            throw new NullPointerException("config can't be null");
        }
        String name = config.getInstanceName();
        ValidationUtil.hasText(name, "instanceName");
        InstanceFuture future = (InstanceFuture)instanceMap.get(name);
        if (future != null) {
            return future.get();
        }
        future = new InstanceFuture();
        InstanceFuture found = instanceMap.putIfAbsent(name, future);
        if (found != null) {
            return found.get();
        }
        try {
            return HazelcastInstanceFactory.constructHazelcastInstance(config, name, new DefaultNodeContext(), future);
        }
        catch (Throwable t) {
            instanceMap.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    public static HazelcastInstance newHazelcastInstance(Config config) {
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        return HazelcastInstanceFactory.newHazelcastInstance(config, config.getInstanceName(), new DefaultNodeContext());
    }

    private static String createInstanceName(Config config) {
        return "_hzInstance_" + factoryIdGen.incrementAndGet() + "_" + config.getGroupConfig().getName();
    }

    public static HazelcastInstance newHazelcastInstance(Config config, String instanceName, NodeContext nodeContext) {
        InstanceFuture future;
        String name;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if ((name = instanceName) == null || name.trim().length() == 0) {
            name = HazelcastInstanceFactory.createInstanceName(config);
        }
        if (instanceMap.putIfAbsent(name, future = new InstanceFuture()) != null) {
            throw new DuplicateInstanceNameException("HazelcastInstance with name '" + name + "' already exists!");
        }
        try {
            return HazelcastInstanceFactory.constructHazelcastInstance(config, name, nodeContext, future);
        }
        catch (Throwable t) {
            instanceMap.remove(name, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static HazelcastInstanceProxy constructHazelcastInstance(Config config, String instanceName, NodeContext nodeContext, InstanceFuture future) {
        HazelcastInstanceProxy proxy;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (tccl == null) {
                Thread.currentThread().setContextClassLoader(HazelcastInstanceFactory.class.getClassLoader());
            }
            HazelcastInstanceImpl hazelcastInstance = new HazelcastInstanceImpl(instanceName, config, nodeContext);
            OutOfMemoryErrorDispatcher.register(hazelcastInstance);
            proxy = new HazelcastInstanceProxy(hazelcastInstance);
            Node node = hazelcastInstance.node;
            Iterator iter = node.getClusterService().getMembers().iterator();
            boolean firstMember = iter.hasNext() && ((Member)iter.next()).localMember();
            int initialWaitSeconds = node.groupProperties.INITIAL_WAIT_SECONDS.getInteger();
            if (initialWaitSeconds > 0) {
                hazelcastInstance.logger.info("Waiting " + initialWaitSeconds + " seconds before completing HazelcastInstance startup...");
                try {
                    Thread.sleep(initialWaitSeconds * 1000);
                    if (firstMember) {
                        node.partitionService.firstArrangement();
                    } else {
                        Thread.sleep(4000L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            int initialMinClusterSize = node.groupProperties.INITIAL_MIN_CLUSTER_SIZE.getInteger();
            while (node.getClusterService().getSize() < initialMinClusterSize) {
                try {
                    hazelcastInstance.logger.info("HazelcastInstance waiting for cluster size of " + initialMinClusterSize);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (initialMinClusterSize > 1) {
                if (firstMember) {
                    node.partitionService.firstArrangement();
                } else {
                    Thread.sleep(3000L);
                }
                hazelcastInstance.logger.info("HazelcastInstance starting after waiting for cluster size of " + initialMinClusterSize);
            }
            future.set(proxy);
            hazelcastInstance.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return proxy;
    }

    public static void shutdownAll() {
        LinkedList<HazelcastInstanceProxy> instances = new LinkedList<HazelcastInstanceProxy>();
        for (InstanceFuture f : instanceMap.values()) {
            try {
                HazelcastInstanceProxy instanceProxy = f.get();
                instances.add(instanceProxy);
            }
            catch (RuntimeException runtimeException) {}
        }
        instanceMap.clear();
        OutOfMemoryErrorDispatcher.clear();
        ManagementService.shutdownAll();
        Collections.sort(instances, new Comparator<HazelcastInstanceProxy>(){

            @Override
            public int compare(HazelcastInstanceProxy o1, HazelcastInstanceProxy o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (HazelcastInstanceProxy proxy : instances) {
            proxy.getLifecycleService().shutdown();
            proxy.original = null;
        }
    }

    static Map<MemberImpl, HazelcastInstanceImpl> getInstanceImplMap() {
        HashMap<MemberImpl, HazelcastInstanceImpl> map = new HashMap<MemberImpl, HazelcastInstanceImpl>();
        for (InstanceFuture f : instanceMap.values()) {
            try {
                HazelcastInstanceProxy instanceProxy = f.get();
                HazelcastInstanceImpl impl = instanceProxy.original;
                if (impl == null) continue;
                map.put(impl.node.getLocalMember(), impl);
            }
            catch (RuntimeException runtimeException) {}
        }
        return map;
    }

    static void remove(HazelcastInstanceImpl instance) {
        OutOfMemoryErrorDispatcher.deregister(instance);
        InstanceFuture future = (InstanceFuture)instanceMap.remove(instance.getName());
        if (future != null) {
            future.get().original = null;
        }
        if (instanceMap.size() == 0) {
            ManagementService.shutdownAll();
        }
    }

    private static class InstanceFuture {
        private volatile HazelcastInstanceProxy hz;
        private volatile Throwable throwable;

        private InstanceFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HazelcastInstanceProxy get() {
            if (this.hz != null) {
                return this.hz;
            }
            boolean restoreInterrupt = false;
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                while (this.hz == null && this.throwable == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignore) {
                        restoreInterrupt = true;
                    }
                }
            }
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
            if (this.hz != null) {
                return this.hz;
            }
            throw new IllegalStateException(this.throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void set(HazelcastInstanceProxy proxy) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.hz = proxy;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFailure(Throwable throwable) {
            InstanceFuture instanceFuture = this;
            synchronized (instanceFuture) {
                this.throwable = throwable;
                this.notifyAll();
            }
        }
    }
}

