/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.client.txn.BaseTransactionRequest;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueuePortableHook;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.transaction.TransactionContext;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class TxnPollRequest
extends BaseTransactionRequest
implements Portable,
SecureRequest {
    String name;
    long timeout;

    public TxnPollRequest() {
    }

    public TxnPollRequest(String name, long timeout) {
        this.name = name;
        this.timeout = timeout;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionContext context = endpoint.getTransactionContext(this.txnId);
        TransactionalQueue queue = context.getQueue(this.name);
        return queue.poll(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeout);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.name = reader.readUTF("n");
        this.timeout = reader.readLong("t");
    }

    @Override
    public Permission getRequiredPermission() {
        return new QueuePermission(this.name, "remove");
    }
}

