/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongDecrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndAlterCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndIncrementCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongIncrementAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicLongSetCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.util.Preconditions;

public class ClientAtomicLongProxy
extends PartitionSpecificClientProxy
implements IAtomicLong {
    public ClientAtomicLongProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongApplyCodec.encodeRequest(this.name, this.toData(function));
        ClientMessage response = this.invokeOnPartition(request);
        AtomicLongApplyCodec.ResponseParameters resultParameters = AtomicLongApplyCodec.decodeResponse(response);
        return (R)this.toObject(resultParameters.response);
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongAlterCodec.encodeRequest(this.name, this.toData(function));
        this.invokeOnPartition(request);
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongAlterAndGetCodec.encodeRequest(this.name, this.toData(function));
        AtomicLongAlterAndGetCodec.ResponseParameters resultParameters = AtomicLongAlterAndGetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        Preconditions.isNotNull(function, "function");
        ClientMessage request = AtomicLongGetAndAlterCodec.encodeRequest(this.name, this.toData(function));
        AtomicLongGetAndAlterCodec.ResponseParameters resultParameters = AtomicLongGetAndAlterCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long addAndGet(long delta) {
        ClientMessage request = AtomicLongAddAndGetCodec.encodeRequest(this.name, delta);
        AtomicLongAddAndGetCodec.ResponseParameters resultParameters = AtomicLongAddAndGetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        ClientMessage request = AtomicLongCompareAndSetCodec.encodeRequest(this.name, expect, update);
        AtomicLongCompareAndSetCodec.ResponseParameters resultParameters = AtomicLongCompareAndSetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long decrementAndGet() {
        ClientMessage request = AtomicLongDecrementAndGetCodec.encodeRequest(this.name);
        AtomicLongDecrementAndGetCodec.ResponseParameters resultParameters = AtomicLongDecrementAndGetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long get() {
        ClientMessage request = AtomicLongGetCodec.encodeRequest(this.name);
        AtomicLongGetCodec.ResponseParameters resultParameters = AtomicLongGetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long getAndAdd(long delta) {
        ClientMessage request = AtomicLongGetAndAddCodec.encodeRequest(this.name, delta);
        AtomicLongGetAndAddCodec.ResponseParameters resultParameters = AtomicLongGetAndAddCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long getAndSet(long newValue) {
        ClientMessage request = AtomicLongGetAndSetCodec.encodeRequest(this.name, newValue);
        AtomicLongGetAndSetCodec.ResponseParameters resultParameters = AtomicLongGetAndSetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long incrementAndGet() {
        ClientMessage request = AtomicLongIncrementAndGetCodec.encodeRequest(this.name);
        AtomicLongIncrementAndGetCodec.ResponseParameters resultParameters = AtomicLongIncrementAndGetCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long getAndIncrement() {
        ClientMessage request = AtomicLongGetAndIncrementCodec.encodeRequest(this.name);
        AtomicLongGetAndIncrementCodec.ResponseParameters resultParameters = AtomicLongGetAndIncrementCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public void set(long newValue) {
        ClientMessage request = AtomicLongSetCodec.encodeRequest(this.name, newValue);
        this.invokeOnPartition(request);
    }

    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

