/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public abstract class ClientListenerServiceImpl
implements ClientListenerService {
    protected final HazelcastClientInstanceImpl client;
    protected final ClientExecutionServiceImpl executionService;
    protected final SerializationService serializationService;
    protected final ClientInvocationService invocationService;
    protected final ILogger logger = Logger.getLogger(ClientListenerService.class);
    protected final ExecutorService registrationExecutor;
    private final ConcurrentMap<Long, EventHandler> eventHandlerMap = new ConcurrentHashMap<Long, EventHandler>();
    private final StripedExecutor eventExecutor;

    public ClientListenerServiceImpl(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        this.client = client;
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.invocationService = client.getInvocationService();
        this.serializationService = client.getSerializationService();
        ThreadGroup threadGroup = client.getThreadGroup();
        String name = client.getName();
        this.eventExecutor = new StripedExecutor(this.logger, name + ".event", threadGroup, eventThreadCount, eventQueueCapacity);
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(threadGroup, classLoader, name + ".eventRegistration-");
        this.registrationExecutor = Executors.newSingleThreadExecutor(threadFactory);
    }

    public void addEventHandler(long callId, EventHandler handler) {
        this.eventHandlerMap.put(callId, handler);
    }

    protected void removeEventHandler(long callId) {
        this.eventHandlerMap.remove(callId);
    }

    protected EventHandler getEventHandler(long callId) {
        return (EventHandler)this.eventHandlerMap.get(callId);
    }

    public void handleClientMessage(ClientMessage clientMessage, Connection connection) {
        try {
            this.eventExecutor.execute(new ClientEventProcessor(clientMessage, (ClientConnection)connection));
        }
        catch (RejectedExecutionException e) {
            this.logger.log(Level.WARNING, " event clientMessage could not be handled ", e);
        }
    }

    public void shutdown() {
        this.eventExecutor.shutdown();
        ClientExecutionServiceImpl.shutdownExecutor("registrationExecutor", this.registrationExecutor, this.logger);
    }

    public StripedExecutor getEventExecutor() {
        return this.eventExecutor;
    }

    public void start() {
    }

    public abstract Collection<ClientEventRegistration> getActiveRegistrations(String var1);

    private final class ClientEventProcessor
    implements StripedRunnable {
        final ClientMessage clientMessage;
        final ClientConnection connection;

        private ClientEventProcessor(ClientMessage clientMessage, ClientConnection connection) {
            this.clientMessage = clientMessage;
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long correlationId = this.clientMessage.getCorrelationId();
                EventHandler eventHandler = (EventHandler)ClientListenerServiceImpl.this.eventHandlerMap.get(correlationId);
                if (eventHandler == null) {
                    ClientListenerServiceImpl.this.logger.warning("No eventHandler for callId: " + correlationId + ", event: " + this.clientMessage + ", connection: " + this.connection);
                    return;
                }
                eventHandler.handle(this.clientMessage);
            }
            finally {
                this.connection.decrementPendingPacketCount();
            }
        }

        @Override
        public int getKey() {
            return this.clientMessage.getPartitionId();
        }
    }
}

