/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.protocol.task.MessageTask;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.quorum.impl.QuorumServiceImpl;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.WaitSupport;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.ResponseNotSentException;
import com.hazelcast.spi.exception.RetryableException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.RemoteInvocationResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationutil.Operations;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.counters.Counter;
import com.hazelcast.util.counters.SwCounter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

class OperationRunnerImpl
extends OperationRunner {
    static final int AD_HOC_PARTITION_ID = -2;
    private final ILogger logger;
    private final OperationServiceImpl operationService;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final AtomicLong executedOperationsCount;
    @Probe(level=ProbeLevel.DEBUG)
    private final Counter count;
    private InternalPartition internalPartition;
    private final OperationResponseHandler remoteResponseHandler;

    public OperationRunnerImpl(OperationServiceImpl operationService, int partitionId) {
        super(partitionId);
        this.operationService = operationService;
        this.logger = operationService.logger;
        this.node = operationService.node;
        this.nodeEngine = operationService.nodeEngine;
        this.remoteResponseHandler = new RemoteInvocationResponseHandler(operationService);
        this.executedOperationsCount = operationService.completedOperationsCount;
        if (partitionId >= 0) {
            this.count = SwCounter.newSwCounter();
            this.nodeEngine.getMetricsRegistry().scanAndRegister(this, "operation.partition[" + partitionId + "]");
        } else {
            this.count = null;
        }
    }

    @Override
    public void run(Runnable task) {
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = task;
        }
        try {
            task.run();
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private boolean publishCurrentTask() {
        boolean isClientRunnable = this.currentTask instanceof MessageTask || this.currentTask instanceof ClientEngineImpl.ClientPacketProcessor;
        return this.getPartitionId() != -2 && (this.currentTask == null || isClientRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Operation op) {
        if (this.count != null) {
            this.count.inc();
        }
        this.executedOperationsCount.incrementAndGet();
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = op;
        }
        try {
            this.checkNodeState(op);
            if (this.timeout(op)) {
                return;
            }
            this.ensureNoPartitionProblems(op);
            this.ensureQuorumPresent(op);
            op.beforeRun();
            if (this.waitingNeeded(op)) {
                return;
            }
            op.run();
            this.handleResponse(op);
            this.afterRun(op);
        }
        catch (Throwable e) {
            this.handleOperationError(op, e);
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private void checkNodeState(Operation op) {
        if (this.node.getState() == NodeState.ACTIVE) {
            return;
        }
        NodeState state = this.node.getState();
        if (state == NodeState.SHUT_DOWN) {
            throw new HazelcastInstanceNotActiveException("This node is shut down! Operation: " + op);
        }
        if (op instanceof AllowedDuringPassiveState) {
            return;
        }
        if (this.nodeEngine.getClusterService().getClusterState() == ClusterState.PASSIVE) {
            throw new IllegalStateException("Cluster is in " + (Object)((Object)ClusterState.PASSIVE) + " state! Operation: " + op);
        }
        if (op.getPartitionId() < 0) {
            throw new HazelcastInstanceNotActiveException("This node is currently passive! Operation: " + op);
        }
        throw new RetryableHazelcastException("This node is currently shutting down! Operation: " + op);
    }

    private void ensureQuorumPresent(Operation op) {
        QuorumServiceImpl quorumService = this.operationService.nodeEngine.getQuorumService();
        quorumService.ensureQuorumPresent(op);
    }

    private boolean waitingNeeded(Operation op) {
        if (!(op instanceof WaitSupport)) {
            return false;
        }
        WaitSupport waitSupport = (WaitSupport)((Object)op);
        if (waitSupport.shouldWait()) {
            this.nodeEngine.getWaitNotifyService().await(waitSupport);
            return true;
        }
        return false;
    }

    private boolean timeout(Operation op) {
        if (!this.operationService.isCallTimedOut(op)) {
            return false;
        }
        CallTimeoutResponse callTimeoutResponse = new CallTimeoutResponse(op.getCallId(), op.isUrgent());
        OperationResponseHandler responseHandler = op.getOperationResponseHandler();
        responseHandler.sendResponse(op, callTimeoutResponse);
        return true;
    }

    private void handleResponse(Operation op) throws Exception {
        boolean returnsResponse = op.returnsResponse();
        int syncBackupCount = this.sendBackup(op);
        if (!returnsResponse) {
            return;
        }
        this.sendResponse(op, syncBackupCount);
    }

    private int sendBackup(Operation op) throws Exception {
        if (!(op instanceof BackupAwareOperation)) {
            return 0;
        }
        int syncBackupCount = 0;
        BackupAwareOperation backupAwareOp = (BackupAwareOperation)((Object)op);
        if (backupAwareOp.shouldBackup()) {
            syncBackupCount = this.operationService.operationBackupHandler.backup(backupAwareOp);
        }
        return syncBackupCount;
    }

    private void sendResponse(Operation op, int syncBackupCount) {
        OperationResponseHandler responseHandler = op.getOperationResponseHandler();
        if (responseHandler == null) {
            throw new IllegalStateException("ResponseHandler should not be null! " + op);
        }
        try {
            Object response = op.getResponse();
            if (syncBackupCount > 0) {
                response = new NormalResponse(response, op.getCallId(), syncBackupCount, op.isUrgent());
            }
            responseHandler.sendResponse(op, response);
        }
        catch (ResponseAlreadySentException e) {
            this.logOperationError(op, e);
        }
    }

    private void afterRun(Operation op) {
        try {
            Notifier notifier;
            op.afterRun();
            if (op instanceof Notifier && (notifier = (Notifier)((Object)op)).shouldNotify()) {
                this.operationService.nodeEngine.getWaitNotifyService().notify(notifier);
            }
        }
        catch (Throwable e) {
            this.logOperationError(op, e);
        }
    }

    protected void ensureNoPartitionProblems(Operation op) {
        int partitionId = op.getPartitionId();
        if (partitionId < 0) {
            return;
        }
        if (partitionId != this.getPartitionId()) {
            throw new IllegalStateException("wrong partition, expected: " + this.getPartitionId() + " but found:" + partitionId);
        }
        if (this.internalPartition == null) {
            this.internalPartition = this.nodeEngine.getPartitionService().getPartition(partitionId);
        }
        if (this.retryDuringMigration(op) && this.internalPartition.isMigrating()) {
            throw new PartitionMigratingException(this.node.getThisAddress(), partitionId, op.getClass().getName(), op.getServiceName());
        }
        Address owner = this.internalPartition.getReplicaAddress(op.getReplicaIndex());
        if (op.validatesTarget() && !this.node.getThisAddress().equals(owner)) {
            throw new WrongTargetException(this.node.getThisAddress(), owner, partitionId, op.getReplicaIndex(), op.getClass().getName(), op.getServiceName());
        }
    }

    private boolean retryDuringMigration(Operation op) {
        return !(op instanceof ReadonlyOperation) && !Operations.isMigrationOperation(op);
    }

    private void handleOperationError(Operation operation, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        try {
            operation.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.logger.warning("While calling 'operation.onFailure(e)'... op: " + operation + ", error: " + e, t);
        }
        operation.logError(e);
        if (e instanceof ResponseNotSentException || !operation.returnsResponse()) {
            return;
        }
        OperationResponseHandler responseHandler = operation.getOperationResponseHandler();
        try {
            if (this.nodeEngine.isRunning()) {
                responseHandler.sendResponse(operation, e);
            } else if (responseHandler.isLocal()) {
                responseHandler.sendResponse(operation, new HazelcastInstanceNotActiveException());
            }
        }
        catch (Throwable t) {
            this.logger.warning("While sending op error... op: " + operation + ", error: " + e, t);
        }
    }

    private void logOperationError(Operation op, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
        }
        op.logError(e);
    }

    @Override
    public void run(Packet packet) throws Exception {
        boolean publishCurrentTask = this.publishCurrentTask();
        if (publishCurrentTask) {
            this.currentTask = packet;
        }
        Connection connection = packet.getConn();
        Address caller = connection.getEndPoint();
        try {
            Object object = this.nodeEngine.toObject(packet);
            Operation op = (Operation)object;
            op.setNodeEngine(this.nodeEngine);
            OperationAccessor.setCallerAddress(op, caller);
            OperationAccessor.setConnection(op, connection);
            this.setCallerUuidIfNotSet(caller, op);
            this.setOperationResponseHandler(op);
            if (!this.ensureValidMember(op)) {
                return;
            }
            if (publishCurrentTask) {
                this.currentTask = null;
            }
            this.run(op);
        }
        catch (Throwable throwable) {
            long callId = IOUtil.extractOperationCallId(packet, this.node.getSerializationService());
            this.operationService.send(new ErrorResponse(throwable, callId, packet.isUrgent()), caller);
            this.logOperationDeserializationException(throwable, callId);
            throw ExceptionUtil.rethrow(throwable);
        }
        finally {
            if (publishCurrentTask) {
                this.currentTask = null;
            }
        }
    }

    private void setOperationResponseHandler(Operation op) {
        OperationResponseHandler handler = this.remoteResponseHandler;
        if (op.getCallId() == 0L || op.getCallId() == Long.MAX_VALUE) {
            if (op.returnsResponse()) {
                throw new HazelcastException("Op: " + op + " can not return response without call-id!");
            }
            handler = OperationResponseHandlerFactory.createEmptyResponseHandler();
        }
        op.setOperationResponseHandler(handler);
    }

    private boolean ensureValidMember(Operation op) {
        if (this.node.clusterService.getMember(op.getCallerAddress()) != null || Operations.isJoinOperation(op) || Operations.isWanReplicationOperation(op)) {
            return true;
        }
        CallerNotMemberException error = new CallerNotMemberException(this.node.getThisAddress(), op.getCallerAddress(), op.getPartitionId(), op.getClass().getName(), op.getServiceName());
        this.handleOperationError(op, error);
        return false;
    }

    private void setCallerUuidIfNotSet(Address caller, Operation op) {
        if (op.getCallerUuid() != null) {
            return;
        }
        MemberImpl callerMember = this.node.clusterService.getMember(caller);
        if (callerMember != null) {
            op.setCallerUuid(callerMember.getUuid());
        }
    }

    public void logOperationDeserializationException(Throwable t, long callId) {
        boolean returnsResponse;
        boolean bl = returnsResponse = callId != 0L;
        if (t instanceof RetryableException) {
            Level level;
            Level level2 = level = returnsResponse ? Level.FINEST : Level.WARNING;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, t.getClass().getName() + ": " + t.getMessage());
            }
        } else if (t instanceof OutOfMemoryError) {
            try {
                this.logger.log(Level.SEVERE, t.getMessage(), t);
            }
            catch (Throwable ignored) {
                this.logger.log(Level.SEVERE, ignored.getMessage(), t);
            }
        } else {
            Level level;
            Level level3 = level = this.nodeEngine.isRunning() ? Level.SEVERE : Level.FINEST;
            if (this.logger.isLoggable(level)) {
                this.logger.log(level, t.getMessage(), t);
            }
        }
    }
}

