/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.util;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.BufferBuilder;
import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.util.collection.Long2ObjectHashMap;
import java.nio.ByteBuffer;

public class ClientMessageReadHandler
implements ReadHandler {
    private final Long2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Long2ObjectHashMap();
    private final MessageHandler delegate;
    private final SwCounter messageCounter;
    private ClientMessage message = ClientMessage.create();

    public ClientMessageReadHandler(SwCounter messageCounter, MessageHandler messageHandler) {
        this.messageCounter = messageCounter;
        this.delegate = messageHandler;
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        int messagesCreated = 0;
        while (src.hasRemaining()) {
            BufferBuilder builder;
            boolean complete = this.message.readFrom(src);
            if (!complete) {
                this.messageCounter.inc(messagesCreated);
                return;
            }
            if (this.message.isFlagSet((short)192)) {
                this.handleMessage(this.message);
                this.message = ClientMessage.create();
                ++messagesCreated;
                continue;
            }
            if (this.message.isFlagSet((short)128)) {
                builder = new BufferBuilder();
                this.builderBySessionIdMap.put(this.message.getCorrelationId(), builder);
                builder.append(this.message.buffer(), 0, this.message.getFrameLength());
            } else {
                builder = this.builderBySessionIdMap.get(this.message.getCorrelationId());
                if (builder.position() == 0) {
                    throw new IllegalStateException();
                }
                builder.append(this.message.buffer(), this.message.getDataOffset(), this.message.getFrameLength() - this.message.getDataOffset());
                if (this.message.isFlagSet((short)64)) {
                    int msgLength = builder.position();
                    ClientMessage cm = ClientMessage.createForDecode(builder.buffer(), 0);
                    cm.setFrameLength(msgLength);
                    this.handleMessage(cm);
                    this.builderBySessionIdMap.remove(this.message.getCorrelationId());
                }
            }
            this.message = ClientMessage.create();
            ++messagesCreated;
        }
    }

    private void handleMessage(ClientMessage message) {
        message.index(message.getDataOffset());
        this.delegate.handleMessage(message);
    }

    public static interface MessageHandler {
        public void handleMessage(ClientMessage var1);
    }
}

