/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Locale LOCALE_INTERNAL = Locale.US;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+)(\\.([\\d]+))?(-[\\w]+)?(-SNAPSHOT)?$");

    private StringUtil() {
    }

    public static String bytesToString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8_CHARSET);
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, UTF8_CHARSET);
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(UTF8_CHARSET);
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static boolean isNullOrEmptyAfterTrim(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().isEmpty();
    }

    public static String upperCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toUpperCase(LOCALE_INTERNAL);
    }

    public static String lowerCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toLowerCase(LOCALE_INTERNAL);
    }

    public static String timeToString(long timeMillis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(new Date(timeMillis));
    }

    public static String timeToStringFriendly(long timeMillis) {
        return timeMillis == 0L ? "never" : StringUtil.timeToString(timeMillis);
    }

    public static int indexOf(String input, char ch, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String input, char ch) {
        return StringUtil.indexOf(input, ch, 0);
    }

    public static int lastIndexOf(String input, char ch, int offset) {
        for (int i = input.length() - 1 - offset; i >= 0; --i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String input, char ch) {
        return StringUtil.lastIndexOf(input, ch, 0);
    }

    public static String[] tokenizeVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] tokens = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens[i] = matcher.group(i + 1);
            }
            return tokens;
        }
        return null;
    }
}

