/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.config.AbstractCacheConfig;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class PreJoinCacheConfig<K, V>
extends CacheConfig<K, V>
implements IdentifiedDataSerializable {
    public PreJoinCacheConfig() {
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig) {
        this(cacheConfig, true);
    }

    public PreJoinCacheConfig(CacheConfig cacheConfig, boolean resolved) {
        cacheConfig.copy(this, resolved);
    }

    @Override
    protected void writeKeyValueTypes(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.getKeyClassName());
        out.writeUTF(this.getValueClassName());
    }

    @Override
    protected void readKeyValueTypes(ObjectDataInput in) throws IOException {
        this.setKeyClassName(in.readUTF());
        this.setValueClassName(in.readUTF());
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 61;
    }

    public CacheConfig asCacheConfig() {
        return this.copy(new CacheConfig(), false);
    }

    @Override
    protected boolean keyValueTypesEqual(AbstractCacheConfig that) {
        if (!this.getKeyClassName().equals(that.getKeyClassName())) {
            return false;
        }
        return this.getValueClassName().equals(that.getValueClassName());
    }
}

