/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.QueryConstants;
import java.io.IOException;
import javax.annotation.Nonnull;

public class BitmapIndexOptions
implements IdentifiedDataSerializable {
    public static final String DEFAULT_UNIQUE_KEY = QueryConstants.KEY_ATTRIBUTE_NAME.value();
    public static final UniqueKeyTransformation DEFAULT_UNIQUE_KEY_TRANSFORMATION = UniqueKeyTransformation.OBJECT;
    private String uniqueKey;
    private UniqueKeyTransformation uniqueKeyTransformation;

    public BitmapIndexOptions() {
        this.uniqueKey = DEFAULT_UNIQUE_KEY;
        this.uniqueKeyTransformation = DEFAULT_UNIQUE_KEY_TRANSFORMATION;
    }

    public BitmapIndexOptions(BitmapIndexOptions bitmapIndexOptions) {
        this.uniqueKey = bitmapIndexOptions.uniqueKey;
        this.uniqueKeyTransformation = bitmapIndexOptions.uniqueKeyTransformation;
    }

    boolean areDefault() {
        return DEFAULT_UNIQUE_KEY.equals(this.uniqueKey) && DEFAULT_UNIQUE_KEY_TRANSFORMATION == this.uniqueKeyTransformation;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public BitmapIndexOptions setUniqueKey(@Nonnull String uniqueKey) {
        Preconditions.checkNotNull(uniqueKey, "unique key can't be null");
        this.uniqueKey = uniqueKey;
        return this;
    }

    public UniqueKeyTransformation getUniqueKeyTransformation() {
        return this.uniqueKeyTransformation;
    }

    public BitmapIndexOptions setUniqueKeyTransformation(@Nonnull UniqueKeyTransformation uniqueKeyTransformation) {
        Preconditions.checkNotNull(uniqueKeyTransformation, "unique key transformation can't be null");
        this.uniqueKeyTransformation = uniqueKeyTransformation;
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.uniqueKey);
        out.writeInt(this.uniqueKeyTransformation.getId());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uniqueKey = in.readString();
        this.uniqueKeyTransformation = UniqueKeyTransformation.fromId(in.readInt());
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 62;
    }

    public String toString() {
        return "BitmapIndexOptions{uniqueKey=" + this.uniqueKey + ", uniqueKeyTransformation=" + (Object)((Object)this.uniqueKeyTransformation) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapIndexOptions that = (BitmapIndexOptions)o;
        if (!this.uniqueKey.equals(that.uniqueKey)) {
            return false;
        }
        return this.uniqueKeyTransformation == that.uniqueKeyTransformation;
    }

    public int hashCode() {
        int result = this.uniqueKey.hashCode();
        result = 31 * result + this.uniqueKeyTransformation.hashCode();
        return result;
    }

    public static enum UniqueKeyTransformation {
        OBJECT("OBJECT", 0),
        LONG("LONG", 1),
        RAW("RAW", 2);

        private final String name;
        private final int id;

        private UniqueKeyTransformation(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static UniqueKeyTransformation fromName(String name) {
            if (StringUtil.isNullOrEmpty(name)) {
                throw new IllegalArgumentException("empty unique key transformation");
            }
            String upperCasedText = name.toUpperCase();
            if (upperCasedText.equals(UniqueKeyTransformation.OBJECT.name)) {
                return OBJECT;
            }
            if (upperCasedText.equals(UniqueKeyTransformation.LONG.name)) {
                return LONG;
            }
            if (upperCasedText.equals(UniqueKeyTransformation.RAW.name)) {
                return RAW;
            }
            throw new IllegalArgumentException("unexpected unique key transformation: " + name);
        }

        public static UniqueKeyTransformation fromId(int id) {
            for (UniqueKeyTransformation transformation : UniqueKeyTransformation.values()) {
                if (transformation.id != id) continue;
                return transformation;
            }
            throw new IllegalArgumentException("unexpected unique key transformation id: " + id);
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.name;
        }
    }
}

