/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.command;

import com.hazelcast.cp.internal.raft.MembershipChangeMode;
import com.hazelcast.cp.internal.raft.command.RaftGroupCmd;
import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;

public class UpdateRaftGroupMembersCmd
extends RaftGroupCmd
implements IdentifiedDataSerializable {
    private Collection<RaftEndpoint> members;
    private RaftEndpoint member;
    private MembershipChangeMode mode;

    public UpdateRaftGroupMembersCmd() {
    }

    public UpdateRaftGroupMembersCmd(Collection<RaftEndpoint> members, RaftEndpoint member, MembershipChangeMode mode) {
        this.members = members;
        this.member = member;
        this.mode = mode;
    }

    public Collection<RaftEndpoint> getMembers() {
        return this.members;
    }

    public RaftEndpoint getMember() {
        return this.member;
    }

    public MembershipChangeMode getMode() {
        return this.mode;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.members.size());
        for (RaftEndpoint member : this.members) {
            out.writeObject(member);
        }
        out.writeObject(this.member);
        out.writeString(this.mode.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int count = in.readInt();
        LinkedHashSet<RaftEndpoint> members = new LinkedHashSet<RaftEndpoint>();
        for (int i = 0; i < count; ++i) {
            RaftEndpoint member = (RaftEndpoint)in.readObject();
            members.add(member);
        }
        this.members = members;
        this.member = (RaftEndpoint)in.readObject();
        this.mode = MembershipChangeMode.valueOf(in.readString());
    }

    public String toString() {
        return "UpdateRaftGroupMembersCmd{members=" + this.members + ", member=" + this.member + ", mode=" + (Object)((Object)this.mode) + '}';
    }
}

