/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.impl;

import com.hazelcast.aws.security.EC2RequestSigner;
import com.hazelcast.aws.utility.CloudyUtility;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescribeInstances {
    private static final String IAM_ROLE_ENDPOINT = "169.254.169.254";
    private EC2RequestSigner rs;
    private AwsConfig awsConfig;
    private String endpoint;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DescribeInstances(AwsConfig awsConfig, String endpoint) throws IOException {
        if (awsConfig == null) {
            throw new IllegalArgumentException("AwsConfig is required!");
        }
        if (awsConfig.getAccessKey() == null && awsConfig.getIamRole() == null) {
            throw new IllegalArgumentException("AWS access key or IAM Role is required!");
        }
        this.awsConfig = awsConfig;
        this.endpoint = endpoint;
        if (awsConfig.getIamRole() != null) {
            this.tryGetDefaultIamRole();
            this.getKeysFromIamRole();
        }
        String timeStamp = this.getFormattedTimestamp();
        this.rs = new EC2RequestSigner(awsConfig, timeStamp, endpoint);
        this.attributes.put("Action", this.getClass().getSimpleName());
        this.attributes.put("Version", "2014-06-15");
        this.attributes.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        this.attributes.put("X-Amz-Credential", this.rs.createFormattedCredential());
        this.attributes.put("X-Amz-Date", timeStamp);
        this.attributes.put("X-Amz-SignedHeaders", "host");
        this.attributes.put("X-Amz-Expires", "30");
    }

    private void tryGetDefaultIamRole() throws IOException {
        InputStreamReader is = null;
        BufferedReader reader = null;
        if (!this.awsConfig.getIamRole().equals("DEFAULT")) {
            return;
        }
        try {
            String query = "latest/meta-data/iam/security-credentials/";
            URL url = new URL("http", IAM_ROLE_ENDPOINT, query);
            is = new InputStreamReader(url.openStream(), "UTF-8");
            reader = new BufferedReader(is);
            this.awsConfig.setIamRole(reader.readLine());
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Invalid Aws Configuration");
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void getKeysFromIamRole() {
        try {
            String query = "latest/meta-data/iam/security-credentials/" + this.awsConfig.getIamRole();
            URL url = new URL("http", IAM_ROLE_ENDPOINT, query);
            InputStreamReader is = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader reader = new BufferedReader(is);
            Map<String, String> map = this.parseIamRole(reader);
            this.awsConfig.setAccessKey(map.get("AccessKeyId"));
            this.awsConfig.setSecretKey(map.get("SecretAccessKey"));
            this.attributes.put("X-Amz-Security-Token", map.get("Token"));
        }
        catch (IOException io) {
            throw new InvalidConfigurationException("Invalid Aws Configuration");
        }
    }

    public Map<String, String> parseIamRole(BufferedReader reader) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern keyPattern = Pattern.compile("\"(.*?)\" : ");
        Pattern valuePattern = Pattern.compile(" : \"(.*?)\",");
        String line = reader.readLine();
        while (line != null) {
            if (line.contains(":")) {
                Matcher keyMatcher = keyPattern.matcher(line);
                Matcher valueMatcher = valuePattern.matcher(line);
                if (keyMatcher.find() && valueMatcher.find()) {
                    String key = keyMatcher.group(1);
                    String value = valueMatcher.group(1);
                    map.put(key, value);
                }
            }
            line = reader.readLine();
        }
        return map;
    }

    private String getFormattedTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> execute() throws Exception {
        Map<String, String> map;
        String signature = this.rs.sign("ec2", this.attributes);
        InputStream stream = null;
        this.attributes.put("X-Amz-Signature", signature);
        try {
            Map<String, String> response;
            stream = this.callService(this.endpoint);
            map = response = CloudyUtility.unmarshalTheResponse(stream, this.awsConfig);
        }
        catch (Throwable throwable) {
            IOUtil.closeResource(stream);
            throw throwable;
        }
        IOUtil.closeResource((Closeable)stream);
        return map;
    }

    private InputStream callService(String endpoint) throws Exception {
        String query = this.rs.getCanonicalizedQueryString(this.attributes);
        URL url = new URL("https", endpoint, -1, "/?" + query);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setRequestMethod("GET");
        httpConnection.setDoOutput(false);
        httpConnection.connect();
        return httpConnection.getInputStream();
    }
}

