/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate3CacheKeySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate3CacheKeySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate3 not available, skipping serializer initialization";
    private final Class<?> cacheKeyClass;

    public Hibernate3CacheKeySerializerHook() {
        Class<?> cacheKeyClass = null;
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            try {
                cacheKeyClass = Class.forName("org.hibernate.cache.CacheKey");
            }
            catch (Exception e) {
                Logger.getLogger(Hibernate3CacheKeySerializerHook.class).finest(SKIP_INIT_MSG);
            }
        }
        this.cacheKeyClass = cacheKeyClass;
    }

    public Class getSerializationType() {
        return this.cacheKeyClass;
    }

    public Serializer createSerializer() {
        if (this.cacheKeyClass != null) {
            return new Hibernate3CacheKeySerializer();
        }
        return null;
    }

    public boolean isOverwritable() {
        return true;
    }
}

